package immibis.ccperiphs.rfid;

import java.util.List;

import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;

public class ItemCardBase extends Item {
	// Colours are stored as item metadata, using wool data values

	public ItemCardBase(int id, int iconBase) {
		super(id);
		setTextureFile("/immibis/ccperiphs/world.png");
		iconIndex = iconBase;
		setItemName("immibis.cc-rfid."+iconBase);
		setMaxStackSize(1);
	}
	
	// Makes the item send its NBT data in packets
	public boolean func_46056_k() {return true;} // 1.2.5 client
	public boolean func_46003_i() {return true;} // 1.2.5 server
	public boolean getShareTag() {return true;} // 1.3.2
	
	// @Override // client only override
	public int getIconFromDamage(int damage) {
		return iconIndex + damage;
	}
	
	// @Override // client only override
	public void addInformation(ItemStack stack, List list) {
		if(stack.stackTagCompound == null || !stack.stackTagCompound.hasKey("data"))
			return;
		
		String line1 = stack.stackTagCompound.getString("line1");
		//String line2 = stack.stackTagCompound.getString("line2");
		//String line3 = stack.stackTagCompound.getString("line3");
		
		if(!line1.equals("")) list.add(line1);
		//if(!line2.equals("")) list.add(line2);
		//if(!line3.equals("")) list.add(line3);
	}

}
