package mods.immibis.infiview;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.Level;

public class CPUThread extends Thread {
	private final List<PendingSaveOperation> saves = new ArrayList<>(3);
	private final List<PendingLoadOperation> loads = new ArrayList<>(3);
	private final List<PendingMergeOperation> merges = new ArrayList<>(3);
	private boolean draining = false;
	private boolean isEmpty = true;
	private Object LOCK = new Object();
	
	{
		setName("InfiView CPU thread");
		setDaemon(true);
		setPriority(MIN_PRIORITY);
	}
	
	@Override
	public void run() {
		while(true) {
			try {
				PendingSaveOperation s = null;
				PendingLoadOperation l = null;
				PendingMergeOperation m = null;
				synchronized(LOCK) {
					while(saves.size() == 0 && loads.size() == 0 && merges.size() == 0 && !draining) {
						isEmpty = true;
						LOCK.wait();
					}
					isEmpty = false;
					if(loads.size() > 0)
						l = loads.remove(loads.size() - 1);
					else if(saves.size() > 0)
						s = saves.remove(saves.size() - 1);
					else if(merges.size() > 0)
						m = merges.remove(merges.size() - 1);
					else if(draining) {
						draining = false;
						LOCK.notifyAll();
					}
				}
				if(l != null)
					l.doDecompressNow();
				if(s != null)
					s.doCompressNow();
				if(m != null)
					m.doCPUOperationNow();
			} catch(Exception | AssertionError e) {
				InfiViewMod.LOGGER.log(Level.WARN, "Unexpected exception caught on I/O thread", e);
			}
		}
	}
	
	public void enqueue(PendingLoadOperation op) {
		synchronized(LOCK) {
			loads.add(op);
			LOCK.notifyAll();
		}
	}
	
	public void enqueue(PendingSaveOperation op) {
		synchronized(LOCK) {
			saves.add(op);
			LOCK.notifyAll();
		}
	}

	public void enqueue(PendingMergeOperation op) {
		synchronized(LOCK) {
			merges.add(op);
			LOCK.notifyAll();
		}
	}

	public boolean drain() throws InterruptedException {
		synchronized(LOCK) {
			if(isEmpty)
				return false;
			draining = true;
			LOCK.notifyAll();
			while(draining)
				LOCK.wait();
			return true;
		}
	}
}
