package mods.immibis.infiview;

import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL15;

public class GLBufferCache {
	
	private final int[] buffers;
	private int freeMask;
	
	public GLBufferCache(int nBuffersExpected, int size) {
		buffers = new int[nBuffersExpected];
		for(int k = 0; k < nBuffersExpected; k++)
			buffers[k] = GL15.glGenBuffers();
		freeMask = (1 << nBuffersExpected) - 1;
	}
	
	public synchronized void returnBuffer(int buffer) {
		for(int k = 0; k < buffers.length; k++) {
			if(buffer == buffers[k]) {
				if((freeMask & (1 << k)) != 0)
					InfiViewMod.LOGGER.log(Level.WARN, "Returning already-returned buffer!");
				freeMask |= 1 << k;
				return;
			}
		}
		GL15.glDeleteBuffers(buffer);
	}
	
	public synchronized int getBuffer() {
		if(freeMask == 0) {
			InfiViewMod.LOGGER.log(Level.WARN, "All pre-allocated buffers exhausted; allocating new buffer", new Exception("Stack trace"));
			return GL15.glGenBuffers();
		}
		for(int k = 0; k < buffers.length; k++) {
			if((freeMask & (1 << k)) != 0) {
				freeMask &= ~(1 << k);
				return buffers[k];
			}
		}
		throw new AssertionError("Shouldn't get here");
	}
}
