package mods.immibis.infiview;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.KHRDebug;

/*
 * TODO: If OpenGL debug output requested, then ASM-patch call to Display.create in Minecraft.startGame to request a debug context (via contextAttribs parameter).
 */
class GLDebugOutputLogger {
	private GLDebugOutputLogger() {}
	
	public static Logger ARB_DEBUG_OUTPUT_LOGGER = LogManager.getLogger("ARB_debug_output");
	static void init() {
		if(GLContext.getCapabilities().GL_ARB_debug_output) {
			boolean enabled = Boolean.getBoolean("immibis.infiview.showGLDebugOutput");
			if(enabled) {
				ARBDebugOutput.glDebugMessageCallbackARB(new ARBDebugOutputCallback(new ARBDebugOutputCallback.Handler() {
					@Override
					public void handleMessage(int source, int type, int id, int severity, String message) {
						if(type == KHRDebug.GL_DEBUG_TYPE_PUSH_GROUP || type == KHRDebug.GL_DEBUG_TYPE_POP_GROUP || type == KHRDebug.GL_DEBUG_TYPE_MARKER)
							return;
						Level level;
						switch(severity) {
						case ARBDebugOutput.GL_DEBUG_SEVERITY_HIGH_ARB:
							level = Level.ERROR;
							break;
						case ARBDebugOutput.GL_DEBUG_SEVERITY_MEDIUM_ARB:
							level = Level.WARN;
							break;
						case ARBDebugOutput.GL_DEBUG_SEVERITY_LOW_ARB:
							level = Level.DEBUG;
							break;
						default:
							level = Level.INFO;
							message = "[Unknown severity "+severity+"] "+message;
							break;
						}
						String sourceStr;
						switch(source) {
						case ARBDebugOutput.GL_DEBUG_SOURCE_API_ARB: sourceStr="API"; break;
						case ARBDebugOutput.GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB: sourceStr="Window system"; break;
						case ARBDebugOutput.GL_DEBUG_SOURCE_SHADER_COMPILER_ARB: sourceStr="Shader compiler"; break;
						case ARBDebugOutput.GL_DEBUG_SOURCE_THIRD_PARTY_ARB: sourceStr="Third-party"; break;
						case ARBDebugOutput.GL_DEBUG_SOURCE_APPLICATION_ARB: sourceStr="Application"; break;
						case ARBDebugOutput.GL_DEBUG_SOURCE_OTHER_ARB: sourceStr="Other"; break;
						default: sourceStr="Unknown source "+source; break;
						}
						String typeStr;
						switch(type) {
						case ARBDebugOutput.GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB: typeStr="Deprecated behaviour"; break;
						case ARBDebugOutput.GL_DEBUG_TYPE_ERROR_ARB: typeStr="Error"; break;
						case ARBDebugOutput.GL_DEBUG_TYPE_OTHER_ARB: typeStr="Other"; break;
						case ARBDebugOutput.GL_DEBUG_TYPE_PERFORMANCE_ARB: typeStr="Performance"; break;
						case ARBDebugOutput.GL_DEBUG_TYPE_PORTABILITY_ARB: typeStr="Portability"; break;
						case ARBDebugOutput.GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB: typeStr="Undefined behaviour"; break;
						default: typeStr="Unknown type "+type; break;
						}
						ARB_DEBUG_OUTPUT_LOGGER.log(level, "["+typeStr+"] ["+sourceStr+"] "+message);
					}
				}));
				InfiViewMod.LOGGER.log(Level.INFO, "ARB_debug_output supported; installed a message callback");
			} else {
				InfiViewMod.LOGGER.log(Level.INFO, "ARB_debug_output supported but not enabled; to show OpenGL debug messages, use -Dimmibis.infiview.showGLDebugOutput=true");
			}
		} else {
			InfiViewMod.LOGGER.log(Level.INFO, "ARB_debug_output not supported; not installing a message callback");
		}
	}
}
