package mods.immibis.infiview;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.apache.logging.log4j.Level;

public class IOThread extends Thread {
	private final List<PendingSaveOperation> saves = new ArrayList<>(3);
	private final List<PendingLoadOperation> loads = new ArrayList<>(3);
	private final List<PendingMergeOperation> merges = new ArrayList<>(3);
	private final List<Runnable> trivialOps = new LinkedList<>();
	private Object LOCK = new Object();
	private boolean draining = false;
	private boolean isEmpty = true;
	
	{
		setName("InfiView bulk I/O thread");
		setDaemon(true);
		setPriority(NORM_PRIORITY + 1);
	}
	
	@Override
	public void run() {
		while(true) {
			try {
				Runnable t = null;
				PendingSaveOperation s = null;
				PendingLoadOperation l = null;
				PendingMergeOperation m = null;
				synchronized(LOCK) {
					while(saves.size() == 0 && loads.size() == 0 && trivialOps.size() == 0 && merges.size() == 0 && !draining) {
						isEmpty = true;
						LOCK.wait();
					}
					isEmpty = false;
					if(trivialOps.size() > 0)
						t = trivialOps.remove(0);
					else if(loads.size() > 0)
						l = loads.remove(loads.size() - 1);
					else if(saves.size() > 0)
						s = saves.remove(saves.size() - 1);
					else if(merges.size() > 0)
						m = merges.remove(merges.size() - 1);
					else if(draining) {
						draining = false;
						LOCK.notifyAll();
					}
				}
				if(t != null)
					t.run();
				if(l != null)
					l.doIOLoadNow();
				if(s != null)
					s.doIOSaveNow();
				if(m != null)
					m.doIOOperationNow();
			} catch(Exception | AssertionError e) {
				InfiViewMod.LOGGER.log(Level.WARN, "Unexpected exception caught on I/O thread", e);
			}
		}
	}
	
	public void enqueue(PendingLoadOperation op) {
		synchronized(LOCK) {
			loads.add(op);
			LOCK.notifyAll();
		}
	}
	
	public void enqueue(PendingSaveOperation op) {
		synchronized(LOCK) {
			saves.add(op);
			LOCK.notifyAll();
		}
	}

	public void enqueueTrivial(Runnable op) {
		synchronized(LOCK) {
			trivialOps.add(op);
			LOCK.notifyAll();
		}
	}

	public void enqueue(PendingMergeOperation op) {
		synchronized(LOCK) {
			merges.add(op);
			LOCK.notifyAll();
		}
	}

	public boolean drain() throws InterruptedException {
		synchronized(LOCK) {
			if(isEmpty)
				return false;
			draining = true;
			LOCK.notifyAll();
			while(draining)
				LOCK.wait();
			return true;
		}
	}
}
