package mods.immibis.infiview;

import mods.immibis.infiview.storage.CachedQuadTreeNode;
import mods.immibis.infiview.storage.QuadTreeVisitResult;
import mods.immibis.infiview.storage.QuadTreeVisitor;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;

public class InfiViewCommand extends CommandBase {

	@Override
	public String getCommandName() {
		return "infiview";
	}

	@Override
	public String getCommandUsage(ICommandSender p_71518_1_) {
		return "/"+getCommandName()+" {reset|status}";
	}

	@Override
	public void processCommand(ICommandSender user, String[] p_71515_2_) {
		String arg0 = (p_71515_2_.length == 0 ? "" : p_71515_2_[0]);
		if(arg0.equals("status")) {
			user.addChatMessage(new ChatComponentText("== InfiView status =="));
			user.addChatMessage(new ChatComponentText("Load operations: "+InfiViewMod.loadQueue.size()+" -> "+ResourceAllocator.loadOperationsAwaitingIO.get()+" -> "+ResourceAllocator.loadOperationsAwaitingCPU.get()));
			user.addChatMessage(new ChatComponentText("Save operations: "+InfiViewMod.saveQueue.size()+" -> "+ResourceAllocator.saveOperationsAwaitingDownload.get()+" -> "+ResourceAllocator.saveOperationsAwaitingCPU.get()+" -> "+ResourceAllocator.saveOperationsAwaitingIO.get()));
			user.addChatMessage(new ChatComponentText("Merge operations: "+InfiViewMod.mergeQueue.size()+" -> "+ResourceAllocator.mergeOperationsRunning.get()));
			user.addChatMessage(new ChatComponentText("Loaded nodes: "+NodeImageData.allNIDs.size()));
			return;
		} else if(arg0.equals("reset")) {
			ResourceAllocator.loadOperationsAwaitingCPU.set(0);
			ResourceAllocator.loadOperationsAwaitingIO.set(0);
			ResourceAllocator.saveOperationsAwaitingCPU.set(0);
			ResourceAllocator.saveOperationsAwaitingIO.set(0);
			ResourceAllocator.saveOperationsAwaitingDownload.set(0);
			ResourceAllocator.mergeOperationsRunning.set(0);
			InfiViewMod.mergeQueue.clear();
			final int flags = (p_71515_2_.length < 2 ? 0 : Integer.parseInt(p_71515_2_[1]));
			InfiViewMod.storageManager.visitLoadedQuadTreeNodes(new QuadTreeVisitor() {
				@Override
				public QuadTreeVisitResult visit(int x, int z, int scale, CachedQuadTreeNode node) {
					node.reset(flags);
					return null;
				}
			});
		}
	}
	
	@Override
	public boolean canCommandSenderUseCommand(ICommandSender p_71519_1_) {
		return true;
	}

}
