package mods.immibis.infiview;

import org.lwjgl.opengl.GL11;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

import net.minecraft.launchwrapper.IClassTransformer;

public class InfiViewTransformer implements IClassTransformer {

	private static class TransformingClassVisitor extends ClassVisitor {

		private String className;
		public TransformingClassVisitor(ClassVisitor parent) {
			super(Opcodes.ASM5, parent);
		}
		
		@Override
		public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
			className = name;
			super.visit(version, access, name, signature, superName, interfaces);
		}
		
		@Override
		public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
			MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
			mv = new MethodVisitor(Opcodes.ASM5, mv) {
				private String lastField;
				private int lastInt;
				@Override
				public void visitFieldInsn(int opcode, String owner, String name, String desc) {
					lastField = name;
					super.visitFieldInsn(opcode, owner, name, desc);
				}
				@Override
				public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
					if(opcode == Opcodes.INVOKESTATIC && owner.equals("org/lwjgl/util/glu/Project") && name.equals("gluPerspective")) {
						// Multiply last parameter (far plane distance) by 1000 before calling gluPerspective.
						super.visitLdcInsn(Float.valueOf(1000.0f));
						super.visitInsn(Opcodes.FMUL);
						// Then set farPlaneDistance to that. (Which was the last field accessed)
						super.visitInsn(Opcodes.DUP);
						super.visitVarInsn(Opcodes.ALOAD, 0);
						super.visitInsn(Opcodes.SWAP);
						super.visitFieldInsn(Opcodes.PUTFIELD, className, lastField, "F");
					}
					super.visitMethodInsn(opcode, owner, name, desc, itf);
				}
				
				@Override
				public void visitIntInsn(int opcode, int operand) {
					lastInt = operand;
					super.visitIntInsn(opcode, operand);
				}
				
				@Override
				public void visitLdcInsn(Object cst) {
					// This value is used to clip farPlaneDistance (as a maximum). Since we increase
					// farPlaneDistance, we need to increase this too or we break fog in the nether.
					if(lastInt == GL11.GL_FOG_END && cst.equals(192.0f)) {
						cst = 192000.0f;
					}
					super.visitLdcInsn(cst);
				}
			};
			return mv;
		}
	}

	@Override
	public byte[] transform(String arg0, String arg1, byte[] arg2) {
		if(!arg1.equals("net.minecraft.client.renderer.EntityRenderer"))
			return arg2;
		
		ClassWriter cw = new ClassWriter(0);
		new ClassReader(arg2).accept(new TransformingClassVisitor(cw), 0);
		return cw.toByteArray();
	}

}
