package mods.immibis.infiview;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;

import org.apache.logging.log4j.Level;

public final class NioBufferCache {
	
	private final int bufferSize;
	private final ArrayList<WeakReference<ByteBuffer>> cache = new ArrayList<>();
	
	public NioBufferCache(int bufferSize) {
		this.bufferSize = bufferSize;
	}
	
	public synchronized void returnBuffer(ByteBuffer buf) {
		if(buf == null)
			InfiViewMod.LOGGER.log(Level.WARN, "Ignoring return of null buffer.", new Exception("Stack trace"));
		else if(buf.capacity() == bufferSize)
			cache.add(new WeakReference<>(buf));
		else
			InfiViewMod.LOGGER.log(Level.WARN, "Ignoring return of wrong-sized buffer. Buffer size is "+buf.capacity()+", but expected "+bufferSize, new Exception("Stack trace"));
	}
	
	public synchronized ByteBuffer getBuffer() {
		while(cache.size() > 0) {
			ByteBuffer buf = cache.remove(cache.size() - 1).get();
			if(buf != null) {
				buf.position(0).limit(bufferSize);
				return buf;
			}
		}
		return ByteBuffer.allocateDirect(bufferSize);
	}
}
