package mods.immibis.infiview;

import static mods.immibis.infiview.InfiViewMod.*;
import static org.lwjgl.opengl.ARBPixelBufferObject.*;
import static org.lwjgl.opengl.GL11.*;
import static org.lwjgl.opengl.GL15.*;

import java.nio.ByteBuffer;

import org.apache.logging.log4j.Level;

import mods.immibis.infiview.capture.CaptureUtils;
import mods.immibis.infiview.capture.InfiViewCapturer;
import mods.immibis.infiview.storage.CachedQuadTreeNode;
import mods.immibis.infiview.storage.ImageJPEGCompressor;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.ChunkCoordinates;

public class PendingSaveOperation {
	private final ChunkCoordinates coords;
	private final CachedQuadTreeNode node;
	private WorldRenderer r;
	
	public PendingSaveOperation(CachedQuadTreeNode node, ChunkCoordinates coords, WorldRenderer r) {
		this.coords = coords;
		this.node = node;
		this.r = r;
	}
	
	private int arrayTex;
	private int pbo;
	
	public void start() {
		// TODO: Is it faster to reuse a rotating pool of textures, or is reusing a single texture okay?
		arrayTex = glGenTextures();
		InfiViewCapturer.capture(r, arrayTex);
		
		ResourceAllocator.saveOperationsAwaitingDownload.incrementAndGet();
		
		textureDownloadQueue.enqueue(this);
	}
	
	public void doDownloadNow() {
		pbo = InfiViewMod.arrayImagePBOs.getBuffer();
		glBindBuffer(GL_PIXEL_PACK_BUFFER_ARB, pbo);
		glBufferData(GL_PIXEL_PACK_BUFFER_ARB, (long)(InfiViewCapturer.ARRAY_TEXTURE_DIMENSION*InfiViewCapturer.ARRAY_TEXTURE_DIMENSION*4), GL_STREAM_READ);
		// TODO: use when supported instead of glBufferData.
		//ARBBufferStorage.glBufferStorage(GL_PIXEL_PACK_BUFFER_ARB, (long)dataSize, GL30.GL_MAP_READ_BIT | ARBBufferStorage.GL_CLIENT_STORAGE_BIT);
		glBindTexture(GL_TEXTURE_2D, arrayTex);
		
		glGetTexImage(GL_TEXTURE_2D, multiSampleLevel, GL_RGBA, GL_UNSIGNED_BYTE, 0L);
		
		glBindBuffer(GL_PIXEL_PACK_BUFFER_ARB, 0);
		
		r = null;
	}

	private static ByteBuffer mappedBuffer = null;
	
	private ByteBuffer imageSeriesBuffer;
	private byte[] compressedImage;
	
	public void onDownloadComplete() {
		assert coords.posY >= 0 && coords.posY <= 15 : "Minichunk Y coordinate out of range. (Do you have Cubic Chunks?)";
		// TODO: support cubic chunks, or mods like that? requires major file format change.
		
		glBindBuffer(GL_PIXEL_PACK_BUFFER_ARB, pbo);
		mappedBuffer = glMapBuffer(GL_PIXEL_PACK_BUFFER_ARB, GL_READ_ONLY, mappedBuffer);
		
		// First, we reorder the data, from a NxN array of textures, into an (N*N)x1 array. (Actually a Mx1 array where M <= N*N)
		// imageSeriesBuffer is the buffer we store the reordered data into.
		
		imageSeriesBuffer = InfiViewMod.renderchunkImageBuffers.getBuffer();
		CaptureUtils.reorderImageSeries(mappedBuffer, imageSeriesBuffer);
		glUnmapBuffer(GL_PIXEL_PACK_BUFFER_ARB);
		glBindBuffer(GL_PIXEL_PACK_BUFFER_ARB, 0);
		glDeleteTextures(arrayTex);
		InfiViewMod.arrayImagePBOs.returnBuffer(pbo);
		
		/* if(isImageBufferEmpty(imageSeriesBuffer)) {
				node.deleteImageAndMarkParentsForUpdate(coords.posY);
				InfiViewMod.renderchunkImageBuffers.returnBuffer(imageSeriesBuffer);
				// TODO: mark the render-chunk for reload.
		*/
		
		ResourceAllocator.saveOperationsAwaitingCPU.incrementAndGet();
		InfiViewMod.cpuThread.enqueue(this);
		ResourceAllocator.saveOperationsAwaitingDownload.decrementAndGet();
	}
	
	public void doCompressNow() {
		
		compressedImage = ImageJPEGCompressor.compressImage(imageSeriesBuffer, InfiViewMod.IMAGE_DIMENSION, InfiViewMod.IMAGE_DIMENSION*InfiViewDirections.NUM_DIRECTIONS);
		InfiViewMod.renderchunkImageBuffers.returnBuffer(imageSeriesBuffer);
		imageSeriesBuffer = null;
		
		ResourceAllocator.saveOperationsAwaitingIO.incrementAndGet();
		InfiViewMod.ioThread.enqueue(this);
		ResourceAllocator.saveOperationsAwaitingCPU.decrementAndGet();
	}
	
	public void doIOSaveNow() {
		node.writeCompressedImageSeriesNow(coords.posY, compressedImage);
		InfiViewMod.LOGGER.log(Level.TRACE, "Wrote an image series.");
		ResourceAllocator.saveOperationsAwaitingIO.decrementAndGet();
		
		InfiViewMod.executeOnMainThread(new Runnable() {
			@Override
			public void run() {
				if(node.loadedImageData != null)
					node.loadedImageData.markMinichunkForReload(coords.posY);
			}
		});
	}
}
