package mods.immibis.infiview;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * We have a pipeline of different things stages that operations go through.
 * Specifically: Disk I/O, CPU-intensive (de)compressing, and texture downloading.
 * 
 * <ul>
 * <li>A load operation can begin when there is at most one load operation in the decompress queue.
 * <li>The CPU task thread will pull the operation off the decompress queue, with no restrictions.
 * <li>The load operation will begin texture uploading when it has been decompressed; there are no restrictions
 * on texture uploading, as it is fast, and OpenGL synchronization is non-trivial.
 * <br>
 * <li>Scratch that. A load operation can begin when there are at most two load operations in (load or decompress) state,
 *     and at most one load operation in load state.
 * <br>
 * <li>A save operation can begin compression when there's at most one save operation waiting for disk I/O,
 * and no load operations waiting for decompression.
 * <li>A save operation can begin disk I/O when there's at most one save operation waiting for compression.
 * <li>A save operation can begin rendering when there's at most one save operation waiting for disk I/O.
 * <br>
 * <li>Scratch that. A save operation can begin when there are at most three save operations in (render or compress or write) state,
 *     and at most two save operations in (render or compress) state,
 *     and at most one save operation in render state.
 * <br>
 * </ul>
 * 
 * ... which one of the above two models? Run some simulations?
 * 
 * <pre>
 * 
 *      SAVE QUEUE ---> RENDER            > I/O ---> DONE
 *                            \          /
 *                             \max1    /
 *                          max1\      /
 *      LOAD QUEUE ---> I/O -----> CPU --> DONE
 *                           prio
 *    ... this diagram is inaccurate, since I/O is also single-threaded and prioritized
 *    Could we ever get into a state of deadlock where a save op is in CPU state waiting for I/O,
 *    and a load op is in I/O state waiting for CPU?
 * 
 * </pre>
 * 
 * A load operation can finish (and start texture upload) as soon as it's done decompressing, no exceptions.
 * The CPU task thread will 
 */
public class ResourceAllocator {
	// Stages are listed here in the order they happen in
	public static AtomicInteger saveOperationsAwaitingDownload = new AtomicInteger(0);
	public static AtomicInteger saveOperationsAwaitingCPU = new AtomicInteger(0);
	public static AtomicInteger saveOperationsAwaitingIO = new AtomicInteger(0);
	
	public static AtomicInteger loadOperationsAwaitingIO = new AtomicInteger(0);
	public static AtomicInteger loadOperationsAwaitingCPU = new AtomicInteger(0);
	
	// For merge operations we don't bother tracking stages, since we can only have one at a time anyway.
	public static AtomicInteger mergeOperationsRunning = new AtomicInteger(0); 
	
	private ResourceAllocator() {}
}
