package mods.immibis.infiview.capture;

import java.nio.ByteBuffer;

import mods.immibis.infiview.InfiViewDirections;
import static mods.immibis.infiview.InfiViewMod.*;

public final class CaptureUtils {
	static final int ARRAY_TEXTURE_DIMENSION = IMAGE_DIMENSION * InfiViewCapturer.IMAGES_IN_ARRAY_BY_DIMENSION;

	public static void reorderImageSeries(ByteBuffer arrayTextureData, ByteBuffer orderedImageData) {
		orderedImageData.position(0).limit(RENDERCHUNK_IMAGE_BYTES);
		for(int direction = 0; direction < InfiViewDirections.NUM_DIRECTIONS; direction++) {
			int imx = direction % InfiViewCapturer.IMAGES_IN_ARRAY_BY_DIMENSION;
			int imy = direction / InfiViewCapturer.IMAGES_IN_ARRAY_BY_DIMENSION;
			
			imx *= IMAGE_DIMENSION;
			imy *= IMAGE_DIMENSION;
			
			// Copy this sub-image into imageWriteBuffer (one row at a time since each row is contiguous).
			int linepos = (imy * ARRAY_TEXTURE_DIMENSION + imx) * 4;
			final int linesize = IMAGE_DIMENSION * 4;
			final int linestride = ARRAY_TEXTURE_DIMENSION * 4;
			for(int ty = 0; ty < IMAGE_DIMENSION; ty++) {
				// Limit must be set first since position must be <= limit (or else position(int) throws IllegalArgumentException).
				arrayTextureData.limit(linepos + linesize);
				arrayTextureData.position(linepos);
				orderedImageData.put(arrayTextureData);
				linepos += linestride;
			}
		}
		orderedImageData.flip();
	}
}
