package mods.immibis.infiview.storage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class ByteBufferInputStream extends InputStream {
	private final ByteBuffer buf;
	public ByteBufferInputStream(ByteBuffer buf) {
		this.buf = buf;
	}
	
	@Override
	public int read() throws IOException {
		if(buf.position() >= buf.limit())
			return -1;
		return buf.get() & 255;
	}
	
	@Override
	public int read(byte[] b) throws IOException {
		return read(b, 0, b.length);
	}
	
	@Override
	public int read(byte[] b, int off, int len) throws IOException {
		int remaining = buf.limit() - buf.position();
		if(remaining == 0)
			return -1;
		
		buf.get(b, off, Math.min(len, remaining));
		return len;
	}
}
