package mods.immibis.infiview.storage;

import java.io.IOException;

import mods.immibis.infiview.InfiViewMod;

public final class UnboundedQuadTreeFileL2 {
	public final UnboundedQuadTreeFileL1 base;
	private final Thread thread;
	public UnboundedQuadTreeFileL2(ExpandableMemoryMappedFile file) throws IOException {
		this.thread = Thread.currentThread();
		this.base = new UnboundedQuadTreeFileL1(file, InfiViewMod.NUM_RENDERCHUNKS_PER_CHUNK*8);
	}
	

	/**
	 * Returns an opaque handle to a specific point where an image series can be attached.
	 */
	public int getImageSeriesRefPoint(int nodeIndex, int posY) {
		//assert Thread.currentThread() == thread;
		assert posY >= 0 && posY < InfiViewMod.NUM_RENDERCHUNKS_PER_CHUNK;
		return base.getNodeDataPosition(nodeIndex) + posY*8;
	}
	
	/**
	 * Returns the ID of the image series currently bound to the given reference point, or -1 if none.
	 */
	public long getImageSeries(int imageSeriesRefPoint) {
		assert Thread.currentThread() == thread;
		return base.file.mapping.getLong(imageSeriesRefPoint);
	}


	public int getRootQuadrantScale(int quadrant) {
		return base.getRootQuadrantScale(quadrant);
	}
	
	public int getRootQuadrantNodeID(int quadrant) {
		return base.getRootQuadrantNodeID(quadrant);
	}


	public long getImageSeries(int nodeIndex, int y) {
		return getImageSeries(getImageSeriesRefPoint(nodeIndex, y));
	}


	public int allocateNewChild(int nodeID, int childNumber) throws IOException {
		return base.allocateNewChild(nodeID, childNumber);
	}


	public void close() {
		base.close();
	}


}
