package immibis.lxp;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class MedallionItem extends Item {
	public static final int MAX_STACK = 4;
	
	public MedallionItem(int i) {
		super(i);
		
		setTextureFile("/immibis/lxp/world.png");
		setIconIndex(3);
		
		setItemName("immibis.lxp.medallion");
		setCreativeTab(CreativeTabs.tabMisc);
		LanguageRegistry.addName(new ItemStack(this, 1, 0), "Empty medallion");
		LanguageRegistry.addName(new ItemStack(this, 1, 1), "Glowing medallion");
		
		setHasSubtypes(true);
		
		setCreativeTab(CreativeTabs.tabMisc);
		
		setMaxStackSize(MAX_STACK);
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	@SideOnly(Side.CLIENT)
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		par3List.add(new ItemStack(this, 1, 0));
		par3List.add(new ItemStack(this, 1, 1));
		par3List.add(new ItemStack(this, 1, 5));
		par3List.add(new ItemStack(this, 1, 10));
		par3List.add(new ItemStack(this, 1, 20));
		par3List.add(new ItemStack(this, 1, 30));
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public int getIconFromDamage(int par1) {
		return (par1 == 0 ? 4 : 3);
	}
	
	@Override
	public String getItemNameIS(ItemStack par1ItemStack) {
		return "immibis.lxp.medallion."+(par1ItemStack.getItemDamage() != 0 ? "charged" : "blank");
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	@SideOnly(Side.CLIENT)
	public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
		super.addInformation(par1ItemStack, par2EntityPlayer, par3List, par4);
		
		if(par1ItemStack.getItemDamage() != 0)
			par3List.add("Level "+par1ItemStack.getItemDamage());
	}
}
