package immibis.lxp;

import immibis.core.TileCombined;

import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class AbsorberTile extends TileCombined implements ITankContainer, ILiquidTank {
	
	private static final int CAPACITY = 1000;
	private double storedLiquid = 0;
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setDouble("stored", storedLiquid);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		storedLiquid = tag.getDouble("stored");
	}
	
	@Override
	public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}

	@Override
	public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}
	
	private ILiquidTank[] tanks = {this};
	@Override
	public ILiquidTank[] getTanks(ForgeDirection direction) {
		return tanks;
	}

	@Override
	public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
		return this;
	}

	@Override
	public LiquidStack getLiquid() {
		if(storedLiquid < 1)
			return null;
		return new LiquidStack(LiquidXPMod.liquid, (int)storedLiquid);
	}

	@Override
	public int getCapacity() {
		return CAPACITY;
	}

	@Override
	public int fill(LiquidStack resource, boolean doFill) {
		if(resource.itemID != LiquidXPMod.liquid.shiftedIndex)
			return 0;
		int toFill = Math.min(resource.amount, (int)(CAPACITY - storedLiquid));
		if(doFill)
			storedLiquid += toFill;
		return toFill;
	}

	@Override
	public LiquidStack drain(int maxDrain, boolean doDrain) {
		maxDrain = Math.min(maxDrain, (int)storedLiquid);
		
		if(doDrain)
			storedLiquid -= maxDrain;
		return maxDrain == 0 ? null : new LiquidStack(LiquidXPMod.liquid, maxDrain);
	}

	@Override
	public int getTankPressure() {
		return 50;
	}

	private void subExperience(EntityPlayer pl, double amt) {
	
		while(amt > 0) {
			double _this = Math.min(amt, pl.experience * pl.xpBarCap());
			pl.experience -= _this / pl.xpBarCap();
			amt -= _this;
			if(pl.experience < 0.001) {
				if(pl.experienceLevel == 0) {
					pl.experience = 0;
					break;
				}
				pl.experienceLevel--;
				pl.experience = 1;
				
				// this sound effect is broken sometimes
				/*if((pl.experienceLevel % 5) == 0) {
					float pitch = Math.min(pl.experienceLevel, 30) * (0.3f / 30) + 0.6f;
					//System.out.println("Pitch "+pitch);
					pl.worldObj.playSoundAtEntity(pl, "random.levelup", 0.75F, pitch);
				}*/
			}
		}
		// these are wrong as experienceTotal is not decreased when the player enchants
		//pl.experienceLevel = LiquidXPMod.xpToLevel(pl.experienceTotal); // make sure level is correct
		//pl.experience = (pl.experienceTotal - LiquidXPMod.levelToXP(pl.experienceLevel)) / (float)pl.xpBarCap(); // and XP bar percentage
		
		if(pl instanceof EntityPlayerMP)
			((EntityPlayerMP)pl).playerNetServerHandler.sendPacketToPlayer(
				new Packet43Experience(pl.experience, pl.experienceTotal, pl.experienceLevel));
	}
	
	@Override
	public void updateEntity() {
		if(worldObj.isRemote)
			return;
		
		for(EntityPlayer pl : (List<EntityPlayer>)worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getAABBPool().addOrModifyAABBInPool(xCoord, yCoord, zCoord, xCoord+1, yCoord+3, zCoord+1))) {
			int realXPTotal = LiquidXPMod.levelToXP(pl.experienceLevel) + (int)(pl.experience * pl.xpBarCap());
			int amt = (int)Math.min((CAPACITY - storedLiquid) * LiquidXPMod.MB_TO_XP, realXPTotal);
			if(amt > 0) {
				subExperience(pl, amt);
				storedLiquid += amt * LiquidXPMod.XP_TO_MB;
			}
		}
		
		if(storedLiquid < 0)
			storedLiquid = 0; // shouldn't happen
		
		for(ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
			if(storedLiquid < 1)
				break;
			
			int x = xCoord + dir.offsetX;
			int y = yCoord + dir.offsetY;
			int z = zCoord + dir.offsetZ;
			
			TileEntity te = worldObj.getBlockTileEntity(x, y, z);
			if(te instanceof ITankContainer) {
				ITankContainer itc = (ITankContainer)te;
				storedLiquid -= itc.fill(dir.getOpposite(), new LiquidStack(LiquidXPMod.liquid, (int)storedLiquid), true);
			}
		}
	}
}
