package immibis.lxp;

import immibis.core.TileBasicInventory;
import immibis.core.api.util.Dir;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class EnchanterTile extends TileBasicInventory implements ISidedInventory {
	public EnchanterTile() {
		super(5, "LXP Enchanter");
	}

	public int front;

	public int clientTicks;
	
	// slot numbers
	public static final int MEDALLION_IN = 0;
	public static final int BOOK_IN = 1;
	public static final int BOOK_OUT = 2;
	public static final int MEDALLION_OUT = 3;
	public static final int TEMPLATE = 4;
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setInteger("front", front);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		front = tag.getInteger("front");
	}
	
	@Override
	public void onPlaced(EntityLiving player, int _) {
		Vec3 look = player.getLook(1.0f);
		
        double absx = Math.abs(look.xCoord);
        double absz = Math.abs(look.zCoord);
        
        if(absx > absz) {
        	if(look.xCoord < 0)
        		front = Dir.PX;
        	else
        		front = Dir.NX;
        } else {
        	if(look.zCoord < 0)
        		front = Dir.PZ;
        	else
        		front = Dir.NZ;
        }
	}
	
	@Override
	public Packet getDescriptionPacket() {
		return new Packet132TileEntityData(xCoord, yCoord, zCoord, front, null);
	}
	
	@Override
	public void onDataPacket(Packet132TileEntityData packet) {
		front = packet.actionType;
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}

	@Override
	public int getStartInventorySide(ForgeDirection side_) {
		int side = side_.ordinal();
		if(side == Dir.NY)
			return MEDALLION_OUT;
		if(side == Dir.PY)
			return MEDALLION_IN;
		if(side == (front ^ 1))
			return TEMPLATE;
		int left = ForgeDirection.ROTATION_MATRIX[Dir.PY][front];
		if(side == left)
			return BOOK_IN;
		if(side == (left ^ 1))
			return BOOK_OUT;
		return 0;
	}

	@Override
	public int getSizeInventorySide(ForgeDirection side) {
		if(side.ordinal() == front)
			return 0;
		else
			return 1;
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		player.openGui(LiquidXPMod.instance, LiquidXPMod.GUI_ENCHANTER, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
	
	@Override
	public void updateEntity() {
		if(worldObj.isRemote) {
			clientTicks++;
			return;
		}
		
		if(inv.contents[BOOK_OUT] != null)
			return;
		
		ItemStack mo = inv.contents[MEDALLION_OUT];
		if(mo != null && (mo.stackSize >= MedallionItem.MAX_STACK || mo.itemID != LiquidXPMod.medallion.shiftedIndex || mo.getItemDamage() != 0))
			return;
		
		ItemStack mi = inv.contents[MEDALLION_IN];
		if(mi == null || mi.itemID != LiquidXPMod.medallion.shiftedIndex || mi.getItemDamage() == 0)
			return;
		
		ItemStack bi = inv.contents[BOOK_IN];
		if(bi == null)
			return;
		
		if(bi.itemID != Item.book.shiftedIndex && LiquidXPMod.ONLY_ENCHANT_BOOKS)
			return;
		
		int level = mi.getItemDamage();
		
		// 60 bookshelves required for max level
		if(level > countBookshelves() / 2)
			return;
		
		ItemStack template = inv.contents[TEMPLATE];
		ItemStack bo = enchant(bi.copy(), level, template);
		if(template != null && template.stackSize <= 0)
			setInventorySlotContents(TEMPLATE, null);
		
		if(bo == null)
			return;
		
		bi.stackSize--;
		mi.stackSize--;
		setInventorySlotContents(BOOK_IN, bi.stackSize == 0 ? null : bi);
		setInventorySlotContents(MEDALLION_IN, mi.stackSize == 0 ? null : mi);
		
		if(mo != null)
			mo.stackSize++;
		else
			mo = new ItemStack(LiquidXPMod.medallion, 1, 0);
		setInventorySlotContents(MEDALLION_OUT, mo);
		
		setInventorySlotContents(BOOK_OUT, bo);
	}
	
	public int countBookshelves() {
		int n = 0;
		int x = xCoord, z = zCoord;
		for(int dy = -1; dy <= 1; dy++) {
			int y = yCoord + dy;
			
			for(int k = -3; k < 3; k++) { // not off by one
				if(worldObj.getBlockId(x+k, y, z+3) == Block.bookShelf.blockID)
					n++;
				if(worldObj.getBlockId(x+k, y, z-3) == Block.bookShelf.blockID)
					n++;
				if(worldObj.getBlockId(x+3, y, z+k) == Block.bookShelf.blockID)
					n++;
				if(worldObj.getBlockId(x-3, y, z+k) == Block.bookShelf.blockID)
					n++;
			}
		}
		return n;
	}
	
	public ItemStack enchant(ItemStack stack, int level, ItemStack template) {
		stack.stackSize = 1;
		
		if(!stack.isItemEnchantable())
			return null;
		
		List<EnchantmentData> enchantments = EnchantmentHelper.buildEnchantmentList(worldObj.rand, template == null ? stack : template, level);
		
		if(enchantments == null)
			return null;

		if(template != null && template.isItemStackDamageable()) {
			int newDamage = template.getItemDamage() + level * 4;
			if(newDamage > template.getMaxDamage())
				template.stackSize = 0;
			else
				template.setItemDamage(newDamage);
		}
		
		if(stack.itemID == Item.book.shiftedIndex)
			stack.itemID = Item.field_92053_bW.shiftedIndex;
        
        // normal enchanting only picks one enchantment if enchanting a book
        // but we use them all
        
        for(EnchantmentData enchantment : enchantments) {
        	if(stack.itemID == Item.field_92053_bW.shiftedIndex)
        		Item.field_92053_bW.func_92060_a(stack, enchantment);
        	else
        		stack.addEnchantment(enchantment.enchantmentobj, enchantment.enchantmentLevel);
        }
        
        return stack;
	}
}
