package immibis.lxp;

import java.util.Iterator;
import java.util.List;

import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class CollectorTile extends LXPEmittingTile {
	
	private static final double RANGE = 6.5;
	
	private static final int CAPACITY = 16000;
	private static final int ATTRACT_LIMIT = 8000; // if storedLiquid >= ATTRACT_LIMIT, it stops working (extra space is left as a buffer.
	
	{
		capacity = CAPACITY;
	}
	
	private int timer = 0;
	private List<EntityXPOrb> entities = null;

	@SuppressWarnings("unchecked")
	@Override
	public void updateEntity() {
		super.updateEntity();
		
		if(worldObj.isRemote)
			return;
		
		timer++;
		
		int extractAmt = (int)Math.ceil(storedLiquid / 3);
		
		for(ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
			if(extractAmt < 1)
				break;
			
			int x = xCoord + dir.offsetX;
			int y = yCoord + dir.offsetY;
			int z = zCoord + dir.offsetZ;
			
			TileEntity te = worldObj.getBlockTileEntity(x, y, z);
			if(te instanceof ITankContainer) {
				ITankContainer itc = (ITankContainer)te;
				int filled = itc.fill(dir.getOpposite(), new LiquidStack(LiquidXPMod.liquid, (int)extractAmt), true);
				extractAmt -= filled;
				storedLiquid -= filled;
			}
		}
		
		if(storedLiquid >= ATTRACT_LIMIT)
			return;
		
		if(timer >= 20 || storedLiquid < CAPACITY/4) {
			timer = 0;
			
			entities = (List<EntityXPOrb>)worldObj.getEntitiesWithinAABB(EntityXPOrb.class, AxisAlignedBB.getAABBPool().addOrModifyAABBInPool(xCoord+0.5-RANGE, yCoord+0.5-RANGE, zCoord+0.5-RANGE, xCoord+0.5+RANGE, yCoord+0.5+RANGE, zCoord+0.5+RANGE));
		}
		
		if(entities == null)
			return;
		
		Iterator<EntityXPOrb> it = entities.iterator();
		while(it.hasNext()) {
			EntityXPOrb orb = it.next();
			
			double dx = xCoord + 0.5 - orb.posX;
			double dy = yCoord + 0.5 - orb.posY;
			double dz = zCoord + 0.5 - orb.posZ;
			double dist = Math.sqrt(dx*dx + dy*dy + dz*dz);
			
			if(dist < 1) {
				orb.setDead();
				it.remove();
				storedLiquid += orb.getXpValue() * LiquidXPMod.XP_TO_MB;

			} else {
				
				double scale = (1/dist) * (8 - dist)/8 * 0.1;
				orb.motionX += dx * scale;
				orb.motionY += dy * scale;
				orb.motionZ += dz * scale;
			}
		}
	}
	
	/*
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		if(worldObj.isRemote)
			return true;
		
		worldObj.setBlockWithNotify(xCoord, yCoord + 1, zCoord, Block.mobSpawner.blockID);
		TileEntityMobSpawner s = (TileEntityMobSpawner)worldObj.getBlockTileEntity(xCoord, yCoord + 1, zCoord);
		
		s.setMobID("Skeleton");
		
		return true;
	}*/

}
