package immibis.lxp;

import immibis.core.TileCombined;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class LXPAcceptingTile extends TileCombined implements ITankContainer, ILiquidTank {
	public double storedLiquid = 0; // can be negative
	public int capacity;
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setDouble("stored", storedLiquid);
		tag.setInteger("capacity", capacity);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		storedLiquid = tag.getDouble("stored");
		capacity = tag.getInteger("capacity");
	}

	@Override
	public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}

	@Override
	public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}
	
	private ILiquidTank[] tanks = {this};
	@Override
	public ILiquidTank[] getTanks(ForgeDirection direction) {
		return tanks;
	}

	@Override
	public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
		return this;
	}

	@Override
	public LiquidStack getLiquid() {
		if(storedLiquid < 1)
			return null;
		return new LiquidStack(LiquidXPMod.liquid, (int)storedLiquid);
	}

	@Override
	public int getCapacity() {
		return capacity;
	}

	@Override
	public int fill(LiquidStack resource, boolean doFill) {
		if(resource.itemID != LiquidXPMod.liquid.shiftedIndex)
			return 0;
		int toFill = Math.min(resource.amount, (int)(capacity - storedLiquid));
		if(doFill)
			storedLiquid += toFill;
		return toFill;
	}

	@Override
	public LiquidStack drain(int maxDrain, boolean doDrain) {
		return null;
	}

	@Override
	public int getTankPressure() {
		return -50;
	}
}
