package mods.immibis.lxp;

import mods.immibis.core.ImmibisCore;
import mods.immibis.core.TileBasicInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class ImprinterTile extends TileBasicInventory implements ITankContainer, ILiquidTank, ISidedInventory {
	
	public ImprinterTile() {
		super(2, "LXP Imprinter");
		setLevelTarget(1);
	}
	
	private static int levelToMB[] = new int[31];
	
	static {
		for(int k = 1; k <= 30; k++)
			levelToMB[k] = (int)(LiquidXPMod.levelToXP(k) * LiquidXPMod.XP_TO_MB);
	}

	public int storedLiquid;
	public int levelTarget;
	public int capacity;
	
	public void setLevelTarget(int i) {
		levelTarget = i;
		capacity = levelToMB[i];
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setInteger("stored", storedLiquid);
		tag.setInteger("level", levelTarget);
		tag.setInteger("capacity", capacity);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		storedLiquid = tag.getInteger("stored");
		levelTarget = tag.getInteger("level");
		capacity = tag.getInteger("capacity");
		
		if(levelTarget < 1 || levelTarget > 30) setLevelTarget(1);
		if(storedLiquid > capacity) storedLiquid = capacity;
	}

	@Override
	public LiquidStack getLiquid() {
		if(storedLiquid == 0)
			return null;
		else
			return new LiquidStack(LiquidXPMod.liquid, storedLiquid);
	}

	@Override
	public int getCapacity() {
		return canRun() ? capacity : storedLiquid;
	}

	@Override
	public int fill(LiquidStack resource, boolean doFill) {
		if(resource.itemID != LiquidXPMod.liquid.itemID)
			return 0;
		int amt = Math.min(resource.amount, capacity - storedLiquid);
		if(doFill)
			storedLiquid += amt;
		return amt;
	}

	@Override
	public LiquidStack drain(int maxDrain, boolean doDrain) {
		maxDrain = Math.min(maxDrain, storedLiquid);
		if(doDrain)
			storedLiquid -= maxDrain;
		return maxDrain == 0 ? null : new LiquidStack(LiquidXPMod.liquid, maxDrain);
	}

	@Override
	public int getTankPressure() {
		return storedLiquid < capacity ? -1 : 0;
	}

	@Override
	public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
		return fill(resource, doFill);
	}

	@Override
	public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}

	@Override
	public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
		return drain(maxDrain, doDrain);
	}

	private ILiquidTank[] tanks = {this};
	@Override
	public ILiquidTank[] getTanks(ForgeDirection direction) {
		return tanks;
	}

	@Override
	public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
		return this;
	}
	
	private boolean canRun() {
		return inv.contents[0] != null && inv.contents[0].itemID == LiquidXPMod.medallion.itemID && inv.contents[0].getItemDamage() == 0;
	}
	
	@Override
	public void updateEntity() {
		super.updateEntity();
		
		if(canRun() && capacity == 0)
			setLevelTarget(levelTarget);
		
		if(canRun() && storedLiquid >= capacity) {
			ItemStack output = new ItemStack(LiquidXPMod.medallion, 1, levelTarget);
			
			if(inv.contents[1] == null || (inv.contents[1].stackSize < MedallionItem.MAX_STACK && ImmibisCore.areItemsEqual(output, inv.contents[1]))) {
				if(inv.contents[1] == null)
					setInventorySlotContents(1, output);
				else {
					inv.contents[1].stackSize++;
					setInventorySlotContents(1, inv.contents[1]);
				}
				
				storedLiquid -= capacity;
				
				if(--inv.contents[0].stackSize == 0) {
					inv.contents[0] = null;
					capacity = 0;
				}
			}
		}
		
		
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		player.openGui(LiquidXPMod.instance, LiquidXPMod.GUI_IMPRINTER, worldObj, xCoord, yCoord, zCoord);
		return true;
	}

	@Override
	public int getStartInventorySide(ForgeDirection side) {
		// top = slot 0
		// bottom = slot 1
		return side.ordinal() ^ 1;
	}

	@Override
	public int getSizeInventorySide(ForgeDirection side) {
		return (side.ordinal() < 2 ? 1 : 0);
	}

}
