package mffs;

import java.util.NoSuchElementException;

public class CoordinateList
{
    private int dataSize = 0;
    private int nCoords = 0;
    private int[] data;

    public CoordinateList(int var1)
    {
        if (var1 < 8)
        {
            var1 = 8;
        }

        this.data = new int[var1 * 3];
    }

    public void add(int var1, int var2, int var3)
    {
        this.add(var1, var2, var3, 0);
    }

    public void add(int var1, int var2, int var3, int var4)
    {
        if (var2 >= 0 && var2 <= 255)
        {
            if (this.data.length == this.dataSize)
            {
                int[] var5 = new int[this.data.length * 2];
                System.arraycopy(this.data, 0, var5, 0, this.dataSize);
                this.data = var5;
            }

            this.data[this.dataSize++] = var1;
            this.data[this.dataSize++] = var2;
            this.data[this.dataSize++] = var3;
            ++this.nCoords;
        }
    }

    public int size()
    {
        return this.nCoords;
    }

    public CoordinateList.CoordIterator iterate()
    {
        return new CoordinateList.CoordIterator();
    }

    public class CoordIterator
    {
        private int pos = 0;
        public int x;
        public int y;
        public int z;

        public boolean hasNext()
        {
            return this.pos < CoordinateList.this.dataSize;
        }

        public void next()
        {
            if (this.pos >= CoordinateList.this.dataSize)
            {
                throw new NoSuchElementException();
            }
            else
            {
                this.x = CoordinateList.this.data[this.pos++];
                this.y = CoordinateList.this.data[this.pos++];
                this.z = CoordinateList.this.data[this.pos++];
            }
        }
    }
}
