package mffs;

import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;

public class TileEntityDirectionalExtender extends TileEntityProjektor
{
    private boolean con_to_projektor = false;
    private int remProjektor_ID = 0;
    private int remGenerator_ID = 0;
    private int wide = 1;
    private int maxwide = 32;
    private int length;
    private int distance;
    private boolean preactive = false;
    private short ausrichtungx;
    private short ausrichtungy;
    private short ausrichtungz;

    public int[] getUpdate()
    {
        return new int[] {this.con_to_projektor ? 1 : 0, this.remProjektor_ID, this.remGenerator_ID, this.wide, this.maxwide, this.length, this.distance, this.preactive ? 1 : 0, this.ausrichtungx, this.ausrichtungy, this.ausrichtungz};
    }

    public void handleUpdate(int[] var1)
    {
        this.con_to_projektor = var1[0] != 0;
        this.remProjektor_ID = var1[1];
        this.remGenerator_ID = var1[2];
        this.wide = var1[3];
        this.maxwide = var1[4];
        this.length = var1[5];
        this.distance = var1[6];
        this.preactive = var1[7] != 0;
        this.ausrichtungx = (short)var1[8];
        this.ausrichtungy = (short)var1[9];
        this.ausrichtungz = (short)var1[10];
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 1:
                    if (!this.getActive() && this.getWide() < this.getMaxwide())
                    {
                        this.setWide(this.getWide() + 1);
                    }

                    break;

                case 2:
                    if (!this.getActive() && this.getWide() > 0)
                    {
                        this.setWide(this.getWide() - 1);
                    }
            }
        }
    }

    public int getMaxwide()
    {
        return this.maxwide;
    }

    public int getWide()
    {
        return this.wide;
    }

    public void setWide(int var1)
    {
        this.wide = var1;
        ++this.updateCount;
    }

    public void setWideinit(int var1)
    {
        this.wide = var1;
    }

    public int getRemGenerator_ID()
    {
        return this.remGenerator_ID;
    }

    public void setRemGenerator_ID(int var1)
    {
        this.remGenerator_ID = var1;
        this.setLinkGenerator_ID(var1);
        ++this.updateCount;
    }

    public boolean isPreactive()
    {
        return this.preactive;
    }

    public void setPreactive(boolean var1)
    {
        this.preactive = var1;
        ++this.updateCount;
    }

    public int getLength()
    {
        return this.length;
    }

    public void setDistance(int var1)
    {
        ++this.updateCount;
        this.distance = var1;
    }

    public void setlength(int var1)
    {
        ++this.updateCount;
        this.length = var1;
    }

    public int getDistance()
    {
        return this.distance;
    }

    public boolean isCon_to_projektor()
    {
        return this.con_to_projektor;
    }

    public void setCon_to_projektor(boolean var1)
    {
        this.con_to_projektor = var1;
        ++this.updateCount;
    }

    public int getRemProjektor_ID()
    {
        return this.remProjektor_ID;
    }

    public void setRemProjektor_ID(int var1)
    {
        this.remProjektor_ID = var1;
        ++this.updateCount;
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.wide = var1.getInt("wide");
        this.length = var1.getInt("length");
        this.distance = var1.getInt("distance");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("wide", this.wide);
        var1.setInt("length", this.length);
        var1.setInt("distance", this.distance);
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.isCreate() && this.getRemGenerator_ID() != 0)
            {
                if (this.isPreactive())
                {
                    this.fieldcalculation(true);
                }

                this.setCreate(false);
            }

            if (this.isPreactive() && !this.isCreate() && !this.getActive())
            {
                this.setActive(true);
                this.fieldcalculation(false);
                this.FieldGenerate(true);
                this.world.notify(this.x, this.y, this.z);
            }

            if (!this.isPreactive() && !this.isCreate() && this.getActive())
            {
                this.setActive(false);
                this.destroyField();
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }
        }
    }

    public void getFieldShape(CoordinateList var1)
    {
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        int var5;
        int var6;

        for (var5 = this.x - 1; var5 <= this.x + 1; ++var5)
        {
            for (var6 = this.y - 1; var6 <= this.y + 1; ++var6)
            {
                for (int var7 = this.z - 1; var7 <= this.z + 1; ++var7)
                {
                    if (this.world.getTypeId(var5, var6, var7) == mod_ModularForceFieldSystem.MFFSMaschines.id && this.world.getData(var5, var6, var7) == 2)
                    {
                        this.ausrichtungx = (short)(this.x - var5);
                        this.ausrichtungy = (short)(this.y - var6);
                        this.ausrichtungz = (short)(this.z - var7);
                    }
                }
            }
        }

        for (var5 = 0; var5 <= this.getWide(); ++var5)
        {
            for (var6 = 1; var6 < this.getLength() + 1; ++var6)
            {
                if (this.getFacing() == 0)
                {
                    var3 = var6 - var6 - var6 - this.getDistance();

                    if (this.ausrichtungx > 0)
                    {
                        var2 = var5;
                    }

                    if (this.ausrichtungx < 0)
                    {
                        var2 = var5 - var5 - var5;
                    }

                    if (this.ausrichtungz > 0)
                    {
                        var4 = var5;
                    }

                    if (this.ausrichtungz < 0)
                    {
                        var4 = var5 - var5 - var5;
                    }
                }

                if (this.getFacing() == 1)
                {
                    var3 = var6 + this.getDistance();

                    if (this.ausrichtungx > 0)
                    {
                        var2 = var5;
                    }

                    if (this.ausrichtungx < 0)
                    {
                        var2 = var5 - var5 - var5;
                    }

                    if (this.ausrichtungz > 0)
                    {
                        var4 = var5;
                    }

                    if (this.ausrichtungz < 0)
                    {
                        var4 = var5 - var5 - var5;
                    }
                }

                if (this.getFacing() == 2)
                {
                    var4 = var6 - var6 - var6 - this.getDistance();

                    if (this.ausrichtungx > 0)
                    {
                        var2 = var5;
                    }

                    if (this.ausrichtungx < 0)
                    {
                        var2 = var5 - var5 - var5;
                    }

                    if (this.ausrichtungy > 0)
                    {
                        var3 = var5;
                    }

                    if (this.ausrichtungy < 0)
                    {
                        var3 = var5 - var5 - var5;
                    }
                }

                if (this.getFacing() == 3)
                {
                    var4 = var6 + this.getDistance();

                    if (this.ausrichtungx > 0)
                    {
                        var2 = var5;
                    }

                    if (this.ausrichtungx < 0)
                    {
                        var2 = var5 - var5 - var5;
                    }

                    if (this.ausrichtungy > 0)
                    {
                        var3 = var5;
                    }

                    if (this.ausrichtungy < 0)
                    {
                        var3 = var5 - var5 - var5;
                    }
                }

                if (this.getFacing() == 4)
                {
                    var2 = var6 - var6 - var6 - this.getDistance();

                    if (this.ausrichtungz > 0)
                    {
                        var4 = var5;
                    }

                    if (this.ausrichtungz < 0)
                    {
                        var4 = var5 - var5 - var5;
                    }

                    if (this.ausrichtungy > 0)
                    {
                        var3 = var5;
                    }

                    if (this.ausrichtungy < 0)
                    {
                        var3 = var5 - var5 - var5;
                    }
                }

                if (this.getFacing() == 5)
                {
                    var2 = var6 + this.getDistance();

                    if (this.ausrichtungz > 0)
                    {
                        var4 = var5;
                    }

                    if (this.ausrichtungz < 0)
                    {
                        var4 = var5 - var5 - var5;
                    }

                    if (this.ausrichtungy > 0)
                    {
                        var3 = var5;
                    }

                    if (this.ausrichtungy < 0)
                    {
                        var3 = var5 - var5 - var5;
                    }
                }

                var1.add(this.x + var2, this.y + var3, this.z + var4);
            }
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int estimateBlockCount()
    {
        return (this.getWide() + 1) * this.getLength();
    }
}
