package mffs;

import ic2.api.Direction;
import ic2.api.EnergyNet;
import ic2.api.ExplosionWhitelist;
import ic2.api.IEnergySink;
import net.minecraft.server.TileEntity;

public class TileEntityGeneratorEUInjector extends TileEntityGeneratorInjector implements IEnergySink
{
    private boolean addedToEnergyNet = false;
    private TileEntityGeneratorCore Core;
    private byte delayupdate = 0;

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (!this.isContocore() && this.getRemGenerator_ID() != 0)
            {
                this.Core = (TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getRemGenerator_ID()));

                if (this.Core != null)
                {
                    this.setContocore(true);
                }
            }

            if (this.isContocore())
            {
                if (this.delayupdate == 20)
                {
                    TileEntity var1 = (TileEntity)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getRemGenerator_ID()));

                    if (var1 == null)
                    {
                        this.setContocore(false);
                        this.setRemGenerator_ID(0);
                    }
                    else if (this.getActive() != ((TileEntityMaschines)var1).getActive())
                    {
                        this.setActive(((TileEntityMaschines)var1).getActive());
                        this.world.k(this.x, this.y, this.z);
                    }

                    this.delayupdate = 0;
                }

                ++this.delayupdate;
            }

            if (!this.addedToEnergyNet)
            {
                EnergyNet.getForWorld(this.world).addTileEntity(this);
                this.addedToEnergyNet = true;
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
                ExplosionWhitelist.addWhitelistedBlock(mod_ModularForceFieldSystem.MFFSMaschines);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
                ExplosionWhitelist.removeWhitelistedBlock(mod_ModularForceFieldSystem.MFFSMaschines);
            }
        }
    }

    /**
     * invalidates a tile entity
     */
    public void j()
    {
        if (!this.world.isStatic && this.addedToEnergyNet)
        {
            EnergyNet.getForWorld(this.world).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }

        super.j();
    }

    public boolean acceptsEnergyFrom(TileEntity var1, Direction var2)
    {
        return true;
    }

    public boolean isAddedToEnergyNet()
    {
        return this.addedToEnergyNet;
    }

    public boolean demandsEnergy()
    {
        return this.isContocore() && this.getActive() ? this.Core.getForcepower() < this.Core.getMaxforcepower() : false;
    }

    public int injectEnergy(Direction var1, int var2)
    {
        if (this.isContocore())
        {
            this.Core.setForcepower(this.Core.getForcepower() + var2 * 10);
            int var3 = 0;

            if (this.Core.getForcepower() > this.Core.getMaxforcepower())
            {
                var3 = this.Core.getForcepower() - this.Core.getMaxforcepower();
                this.Core.setForcepower(this.Core.getMaxforcepower());
            }

            return var3 / 10;
        }
        else
        {
            return var2;
        }
    }
}
