package mffs;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;

public abstract class TileEntityProjektor extends TileEntityMaschines
{
    private ItemStack[] ProjektorItemStacks;
    private boolean camouflage;
    private boolean zapper;
    private boolean dropper;
    private boolean Subwater;
    private boolean Dome;
    private boolean hardner;
    private int Projektor_ID;
    private int linkGenerator_ID;
    private boolean linkGenerator;
    private int linkPower;
    private int maxlinkPower;
    private short ticker;
    private int fpcost;
    private boolean create;
    private int energy_ticker = 0;
    private short ffmeta;
    private int textur;
    protected short specialffmeta = -1;
    protected StringBuffer hasher = new StringBuffer();
    protected Set field_queue = new HashSet();
    private CoordinateList fieldBlocks = null;

    public void handleBaseUpdate(int[] var1)
    {
        this.Projektor_ID = var1[0];
        this.linkGenerator_ID = var1[1];
        this.linkPower = var1[2];
        this.maxlinkPower = var1[3];
        this.textur = var1[4];
    }

    public int[] getBaseUpdate()
    {
        return new int[] {this.Projektor_ID, this.linkGenerator_ID, this.linkPower, this.maxlinkPower, this.textur};
    }

    public TileEntityProjektor()
    {
        Random var1 = new Random();
        this.ProjektorItemStacks = new ItemStack[1];
        this.linkGenerator_ID = 0;
        this.Projektor_ID = var1.nextInt();
        this.linkGenerator = false;
        this.linkPower = 0;
        this.maxlinkPower = 1000000;
        this.ticker = 0;
        this.create = true;
        this.Subwater = false;
        this.Dome = false;
        this.hardner = false;
        this.dropper = true;
        this.zapper = false;
        this.camouflage = false;
        this.textur = -1;
        this.ffmeta = 0;
    }

    public final void addtogrid()
    {
        if (this.world.isStatic)
        {
            throw new RuntimeException("do not call this on smp clients");
        }
        else
        {
            Linkgrid.getWorldMap(this.world).getProjektor().put(Integer.valueOf(this.getProjektor_ID()), this);
        }
    }

    public final void removefromgrid()
    {
        if (this.world.isStatic)
        {
            throw new RuntimeException("do not call this on smp clients");
        }
        else
        {
            Linkgrid.getWorldMap(this.world).getProjektor().remove(Integer.valueOf(this.getProjektor_ID()));
        }
    }

    public abstract int estimateBlockCount();

    public void checkupgrades()
    {
        this.setSubwater(false);
        this.setDome(false);
        this.setHardner(false);
        this.setZapper(false);
        this.setCamouflage(false);

        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    if (this.world.getTypeId(var1, var2, var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(var1, var2, var3);
                        TileEntity var5 = this.world.getTileEntity(var1, var2, var3);

                        if (var5 != null)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0 && (var4 == 1 || var4 == 2 || var4 == 3 || var4 == 6 || var4 == 7))
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (var4 == 7 && ((TileEntityCamoflageUpgrade)var5).getItem_ID() != this.getTextur())
                            {
                                this.setTextur(((TileEntityCamoflageUpgrade)var5).getItem_ID());
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                                }

                                switch (var4)
                                {
                                    case 1:
                                        this.setSubwater(true);
                                        break;

                                    case 2:
                                        this.setDome(true);
                                        break;

                                    case 3:
                                        this.setHardner(true);

                                    case 4:
                                    case 5:
                                    default:
                                        break;

                                    case 6:
                                        this.setZapper(true);
                                        break;

                                    case 7:
                                        this.setCamouflage(true);
                                }
                            }
                        }
                    }
                }
            }
        }

        if (this.specialffmeta != -1)
        {
            this.setffmeta(this.specialffmeta);
        }
        else if (this.isCamouflage())
        {
            this.setffmeta((short)2);
        }
        else if (this.isZapper())
        {
            this.setffmeta((short)1);
        }
        else
        {
            this.setffmeta((short)0);
        }
    }

    protected abstract void getFieldShape(CoordinateList var1);

    protected final void fieldcalculation(boolean var1)
    {
        if (var1 || this.fieldBlocks == null)
        {
            this.fieldBlocks = new CoordinateList(this.estimateBlockCount());
            this.getFieldShape(this.fieldBlocks);
        }

        this.field_queue.clear();

        for (CoordinateList.CoordIterator var2 = this.fieldBlocks.iterate(); var2.hasNext(); this.field_queue.add(this.hasher.toString()))
        {
            var2.next();
            this.hasher.setLength(0);
            this.hasher.append(var2.x).append("/").append(var2.y).append("/").append(var2.z);
            ForceFieldWorldMap var3 = WorldMap.getForceFieldforWorld(this.world).addandgetffmp(var2.x, var2.y, var2.z);
            boolean var4 = !this.world.getMaterial(var2.x, var2.y, var2.z).isBuildable();
            boolean var5 = this.world.getTypeId(var2.x, var2.y, var2.z) == mod_ModularForceFieldSystem.MFFSFieldblock.id;

            if (var5)
            {
                var4 = true;
            }

            if (var3.listsize() == 0)
            {
                var3.ffworld_addFirst(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var4, true, this.getffmeta()));
            }
            else
            {
                var3.ffworld_addLast(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var4, false, this.getffmeta()));
            }
        }
    }

    public void onActivateProjector() {}

    public void onDeactivateProjector() {}

    public void onEveryTick() {}

    public void onFieldTick() {}

    public boolean overrideActivationStatus(boolean var1)
    {
        return var1;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.isCreate() && this.getLinkGenerator_ID() != 0)
            {
                this.addtogrid();
                this.addfreqcard();
                this.setCreate(false);

                if (this.getActive())
                {
                    this.checkupgrades();
                    this.onActivateProjector();
                    this.fieldcalculation(true);
                }
            }

            if (this.getLinkGenerator_ID() != 0)
            {
                this.setLinkGenerator(true);

                try
                {
                    this.setLinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getForcepower());
                    this.setMaxlinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getMaxforcepower());
                }
                catch (NullPointerException var4)
                {
                    this.setLinkGenerator(false);
                    this.setLinkPower(0);
                    this.setMaxlinkPower(1000000);
                }
            }
            else
            {
                this.setLinkGenerator(false);
                this.setLinkPower(0);
                this.setMaxlinkPower(1000000);
            }

            boolean var1 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);
            boolean var3 = this.overrideActivationStatus(var1 || var2);

            if (var3 && this.isLinkGenerator() && this.getLinkPower() > this.Forcepowerneed(this.estimateBlockCount(), true) && !this.getActive())
            {
                this.setActive(true);
                this.fieldcalculation(true);
                this.FieldGenerate(true);
                this.onActivateProjector();
                this.world.notify(this.x, this.y, this.z);
            }

            if ((!var3 || !this.isLinkGenerator() || this.getLinkPower() < this.Forcepowerneed(this.estimateBlockCount(), false)) && this.getActive())
            {
                this.setActive(false);
                this.onDeactivateProjector();
                this.destroyField();
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }

            this.onEveryTick();

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getTicker() == 10)
            {
                this.checkupgrades();
                this.addfreqcard();
                this.onFieldTick();
                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    public final void destroyField()
    {
        Iterator var1 = this.field_queue.iterator();

        while (var1.hasNext())
        {
            String var2 = (String)var1.next();
            ForceFieldWorldMap var3 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var2.toString());

            if (var3.listsize() >= 1)
            {
                if (var3.ffworld_getfirstfreespace() && var3.ffworld_getfistactive() && var3.ffworld_getfirstProjektor_ID() == this.getProjektor_ID())
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                    this.world.setTypeId(var3.getX(), var3.getY(), var3.getZ(), 0);

                    if (var3.listsize() >= 1)
                    {
                        var3.ffworld_setfistactive(true);
                        var3.ffworld_setfirstfreeospace(false);
                    }
                }
                else
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                }
            }
        }

        this.field_queue.clear();
    }

    public boolean isCreate()
    {
        return this.create;
    }

    public void setCreate(boolean var1)
    {
        this.create = var1;
    }

    public short getTicker()
    {
        return this.ticker;
    }

    public void setTicker(short var1)
    {
        this.ticker = var1;
    }

    public int getTextur()
    {
        return this.textur;
    }

    public void setTextur(int var1)
    {
        this.textur = var1;
        ++this.baseUpdateCount;
    }

    public short getffmeta()
    {
        return this.ffmeta;
    }

    public void setffmeta(short var1)
    {
        this.ffmeta = var1;
    }

    public int getMaxlinkPower()
    {
        return this.maxlinkPower;
    }

    public void setMaxlinkPower(int var1)
    {
        this.maxlinkPower = var1;
        ++this.baseUpdateCount;
    }

    public boolean isLinkGenerator()
    {
        return this.linkGenerator;
    }

    public void setLinkGenerator(boolean var1)
    {
        this.linkGenerator = var1;
        ++this.baseUpdateCount;
    }

    public int getLinkPower()
    {
        return this.linkPower;
    }

    public void setLinkPower(int var1)
    {
        this.linkPower = var1;
        ++this.baseUpdateCount;
    }

    public int getLinkGenerator_ID()
    {
        return this.linkGenerator_ID;
    }

    public void setLinkGenerator_ID(int var1)
    {
        this.linkGenerator_ID = var1;
        ++this.baseUpdateCount;
    }

    public boolean isCamouflage()
    {
        return this.camouflage;
    }

    public void setCamouflage(boolean var1)
    {
        this.camouflage = var1;
    }

    public boolean isZapper()
    {
        return this.zapper;
    }

    public void setZapper(boolean var1)
    {
        this.zapper = var1;
    }

    public boolean isSubwater()
    {
        return this.Subwater;
    }

    public void setSubwater(boolean var1)
    {
        this.Subwater = var1;
    }

    public boolean isDome()
    {
        return this.Dome;
    }

    public void setDome(boolean var1)
    {
        this.Dome = var1;
    }

    public boolean isDropper()
    {
        return this.dropper;
    }

    public void setDropper(boolean var1)
    {
        this.dropper = var1;
    }

    public boolean isHardner()
    {
        return this.hardner;
    }

    public void setHardner(boolean var1)
    {
        this.hardner = var1;
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.Projektor_ID = var1.getInt("Projektor_ID");
        this.ffmeta = var1.getShort("ffmeta");
        this.textur = var1.getInt("textur");
        NBTTagList var2 = var1.getList("Items");
        this.ProjektorItemStacks = new ItemStack[this.getSize()];

        for (int var3 = 0; var3 < var2.size(); ++var3)
        {
            NBTTagCompound var4 = (NBTTagCompound)var2.get(var3);
            byte var5 = var4.getByte("Slot");

            if (var5 >= 0 && var5 < this.ProjektorItemStacks.length)
            {
                this.ProjektorItemStacks[var5] = ItemStack.a(var4);
            }
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("Projektor_ID", this.Projektor_ID);
        var1.setShort("ffmeta", this.ffmeta);
        var1.setInt("textur", this.textur);
        NBTTagList var2 = new NBTTagList();

        for (int var3 = 0; var3 < this.ProjektorItemStacks.length; ++var3)
        {
            if (this.ProjektorItemStacks[var3] != null)
            {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.ProjektorItemStacks[var3].save(var4);
                var2.add(var4);
            }
        }

        var1.set("Items", var2);
    }

    public int getProjektor_ID()
    {
        return this.Projektor_ID;
    }

    public void Hardnerdrop(int var1, int var2, int var3)
    {
        int var4 = this.world.getTypeId(var1, var2, var3);
        int var5 = this.world.getData(var1, var2, var3);

        if (var4 >= 122)
        {
            var4 = 0;
        }

        switch (var4)
        {
            case 1:
                var4 = 4;
                var5 = 0;
                break;

            case 2:
            case 60:
                var4 = 3;
                var5 = 0;
                break;

            case 7:
            case 8:
            case 9:
            case 10:
            case 11:
            case 51:
            case 54:
            case 69:
            case 90:
                var4 = 0;
                break;

            case 26:
                var4 = 355;
                var5 = 0;
                break;

            case 55:
                var4 = 331;
                var5 = 0;
                break;

            case 63:
            case 68:
                var4 = 323;
                var5 = 0;
                break;

            case 83:
                var4 = 338;
                var5 = 0;
                break;

            case 93:
            case 94:
                var4 = 356;
                var5 = 0;
        }

        if (var4 != 0)
        {
            if (this.dropper)
            {
                ItemStack var6 = new ItemStack(var4, 1, var5);
                EntityItem var7 = new EntityItem(this.world, (double)var1, (double)var2, (double)var3, var6);
                this.world.addEntity(var7);
            }

            this.world.setTypeId(var1, var2, var3, 0);
        }
    }

    public void FieldGenerate(boolean var1)
    {
        int var2 = 0;
        short var3 = 400;

        if (!var1 && this.energy_ticker != 20)
        {
            ++this.energy_ticker;

            if (mod_ModularForceFieldSystem.slowGenerate)
            {
                return;
            }
        }
        else
        {
            Iterator var4 = this.field_queue.iterator();

            while (var4.hasNext())
            {
                String var5 = (String)var4.next();
                ForceFieldWorldMap var6 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var5.toString());

                if (var6.ffworld_getfirstfreespace())
                {
                    TileEntity var7 = (TileEntity)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(var6.ffworld_getfirstGenerator_ID()));

                    if (var7 instanceof TileEntityGeneratorCore && var7 != null)
                    {
                        boolean var8 = false;
                        int var13;

                        if (var1)
                        {
                            var13 = mod_ModularForceFieldSystem.forcefieldblockcost * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier;
                        }
                        else
                        {
                            var13 = mod_ModularForceFieldSystem.forcefieldblockcost;
                        }

                        if (var6.ffworld_getfistmode() == 1)
                        {
                            var13 *= mod_ModularForceFieldSystem.forcefieldblockzappermodifier;
                        }

                        ((TileEntityGeneratorCore)var7).Energylost(var13);
                    }
                }
            }

            this.energy_ticker = 0;
        }

        LinkedList var9 = new LinkedList();
        Iterator var10 = this.field_queue.iterator();

        while (var10.hasNext())
        {
            String var11 = (String)var10.next();

            if (var2 == var3)
            {
                break;
            }

            ForceFieldWorldMap var12 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var11);

            if (var12.ffworld_getfirstProjektor_ID() == this.getProjektor_ID() && var12.ffworld_getfistactive() && this.world.getChunkAtWorldCoords(var12.getX(), var12.getZ()).d)
            {
                if (var12.getY() >= 0 && var12.getY() < this.world.getHeight())
                {
                    if (this.hardner)
                    {
                        this.Hardnerdrop(var12.getX(), var12.getY(), var12.getZ());
                    }

                    if (!var12.ffworld_getfirstfreespace() && !this.world.getMaterial(var12.getX(), var12.getY(), var12.getZ()).isBuildable() && this.world.getTypeId(var12.getX(), var12.getY(), var12.getZ()) <= 124)
                    {
                        var12.ffworld_setfirstfreeospace(true);
                    }

                    if (var12.ffworld_getfirstfreespace() && (this.world.getTypeId(var12.getX(), var12.getY(), var12.getZ()) != mod_ModularForceFieldSystem.MFFSFieldblock.id || !var12.getsync()))
                    {
                        var12.setsync(true);
                        this.world.setTypeIdAndData(var12.getX(), var12.getY(), var12.getZ(), mod_ModularForceFieldSystem.MFFSFieldblock.id, var12.ffworld_getfistmode());

                        if (var12.ffworld_getfistmode() == 2)
                        {
                            TileCamouflagedField var14 = (TileCamouflagedField)this.world.getTileEntity(var12.getX(), var12.getY(), var12.getZ());
                            var14.camoBlockId = this.getTextur();
                        }

                        ++var2;
                    }
                }
                else
                {
                    var9.add(var11);
                }
            }
        }

        this.field_queue.removeAll(var9);
    }

    public int Forcepowerneed(int var1, boolean var2)
    {
        int var3 = var1 * mod_ModularForceFieldSystem.forcefieldblockcost;

        if (var2)
        {
            var3 = var3 * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier + var3 * 5;
        }

        return var3;
    }

    public void addfreqcard()
    {
        if (this.getItem(0) != null)
        {
            if (this.getItem(0).getItem() == mod_ModularForceFieldSystem.MFFSitemfc && this.linkGenerator_ID != Functions.getTAGfromItemstack(this.getItem(0)).getInt("Generator_ID"))
            {
                this.linkGenerator_ID = Functions.getTAGfromItemstack(this.getItem(0)).getInt("Generator_ID");
            }
        }
        else
        {
            this.linkGenerator_ID = 0;
        }
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.ProjektorItemStacks[var1] != null)
        {
            ItemStack var3;

            if (this.ProjektorItemStacks[var1].count <= var2)
            {
                var3 = this.ProjektorItemStacks[var1];
                this.ProjektorItemStacks[var1] = null;
                return var3;
            }
            else
            {
                var3 = this.ProjektorItemStacks[var1].a(var2);

                if (this.ProjektorItemStacks[var1].count == 0)
                {
                    this.ProjektorItemStacks[var1] = null;
                }

                return var3;
            }
        }
        else
        {
            return null;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.ProjektorItemStacks[var1] = var2;

        if (var2 != null && var2.count > this.getMaxStackSize())
        {
            var2.count = this.getMaxStackSize();
        }
    }

    public boolean canInteractWith(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.e((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.ProjektorItemStacks[var1];
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "Projektor";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 1;
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.ProjektorItemStacks.length;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.f((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    public void f() {}

    public void g() {}
}
