package mffs;

import mffs.*;
import mffs.packet.PacketGenericUpdate;
import ic2.api.ExplosionWhitelist;
import ic2.api.Items;
import immibis.core.ModInfoReader;
import immibis.core.NonSharedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;

import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.server.*;
import forge.*;

public class mod_ModularForceFieldSystem extends NetworkMod implements IGuiHandler {


	public static Configuration config;
	
	public static Block MFFSMaschines;
	public static Block MFFSUpgrades;
	public static Block MFFSFieldblock;
	
	public static Item MFFSitemMFDReaktorlink;
	public static Item MFFSitemMFDwrench;
	public static Item MFFSitemMFDidtool;
	public static Item MFFSitemMFDdebugger;
	public static Item MFFSitemcardempty;
	public static Item MFFSitemfc;
	public static Item MFFSitemidc;
	public static Item MFFSitemsclc;
	
	public static final int GUI_ID_GENERATOR = 1;
	public static final int GUI_AREA_PROJECTOR = 2;
	public static final int GUI_DIRECTIONAL_PROJECTOR = 3;
	public static final int GUI_DEFLECTOR_PROJECTOR = 4;
	public static final int GUI_DIRECTIONAL_UPGRADE = 5;
	public static final int GUI_TUBE_PROJECTOR = 6;
	public static final int GUI_CAMOFLAGE_UPGRADE = 7;
	public static final int GUI_REACTOR_FIELD = 8;
	public static final int GUI_REACTOR_COOLER = 9;
	public static final int GUI_REACTOR_MONITOR = 10;
	public static final int GUI_REACTOR_MONITOR_CLIENT = 11;
	public static final int GUI_REACTOR_MONITOR_REMOTE = 12;

	public static final String CHANNEL = "MFFS-immiSMP";

	public static final byte PKT_GENERIC_UPDATE = 0;
	public static final byte PKT_PROJECTOR_DESCRIPTION = 1;
	
	public static int forcefieldblockcost;
	public static int forcefieldblockcreatemodifier;
	public static int forcefieldblockzappermodifier;
	
	public static int reaktorheatcontrolice;
	public static int reaktorheatcontrolwater;
	public static int reaktorheatcontrollava;
	
	@Override
	public String getPriorities() {
		return "after:mod_IC2;after:mod_ImmibisCore";
	}

	public static StringBuffer hasher = new StringBuffer();
	public static Map<Integer, Integer[]> idtotextur = new Hashtable<Integer, Integer[]>();
	
	public static mod_ModularForceFieldSystem instance;

	public static boolean slowGenerate;

	public mod_ModularForceFieldSystem() {
		instance = this;
	}
	
	@Override
	public void load() {
		try {
			config = new Configuration(new File(Functions.getMinecraftDir(), "/config/ModularForceFieldSystem.cfg"));
			config.load();
		} catch (Exception exception) {
			config = null;
			System.err.print(exception.toString());
		}
		
		Property oldNamesProp = config.getOrCreateBooleanProperty("useOldNames", Configuration.CATEGORY_GENERAL, false);
		oldNamesProp.comment = "If true, this will use the old names from Thunderdark's version.";
		boolean oldNames = Boolean.valueOf(oldNamesProp.value);
		
		Property slowGenerateProp = config.getOrCreateBooleanProperty("slowGenerate", Configuration.CATEGORY_GENERAL, NonSharedProxy.SERVER);
		slowGenerateProp.comment = "If true, forcefields will generate at 400 blocks/second, otherwise 400 blocks/tick (8000/second).";		
		slowGenerate = Boolean.valueOf(slowGenerateProp.value);

		reaktorheatcontrolice = Functions.getBlockIdFor("reaktorheatcontrolice", 100);
		reaktorheatcontrolwater = Functions.getBlockIdFor("reaktorheatcontrolwater", 50);
		reaktorheatcontrollava = Functions.getBlockIdFor("reaktorheatcontrollava", 100);
		
		forcefieldblockcost = Functions.getBlockIdFor("forcefieldblockcost", 1);
		forcefieldblockcreatemodifier = Functions.getBlockIdFor("forcefieldblockcreatemodifier", 10);
		forcefieldblockzappermodifier = Functions.getBlockIdFor("forcefieldblockzappermodifier", 2);

		MFFSFieldblock = new BlockForceField(Functions.getBlockIdFor("HFFPFieldblock", 255));
		MFFSMaschines = new BlockMachine(Functions.getBlockIdFor("HFFPMaschines", 253));
		MFFSUpgrades = new BlockUpgrades(Functions.getBlockIdFor("HFFSUpgrades", 254));

		MFFSitemMFDReaktorlink = new ItemMFD_Reaktorlink(Functions.getItemIdFor("itemMFDReaktorlink", 11110)).a("itemMFDReaktorlink");
		MFFSitemMFDdebugger = new ItemMFD_debuger(Functions.getItemIdFor("itemMFDdebugger", 11111)).a("itemMFDdebugger");
		MFFSitemMFDidtool = new ItemMFD_IDwriter(Functions.getItemIdFor("itemMFDidtool", 11112)).a("itemMFDidtool");
		MFFSitemMFDwrench = new ItemMFD_wrench(Functions.getItemIdFor("itemMFDwrench", 11114)).a("itemMFDwrench");
		MFFSitemcardempty = new ItemCardempty(Functions.getItemIdFor("itemcardempty", 11115)).a("itemcardempty");
		MFFSitemfc = new ItemFrequenzCard(Functions.getItemIdFor("itemfc", 11116)).a("itemfc");
		MFFSitemidc = new ItemIDCard(Functions.getItemIdFor("itemidc", 11117)).a("itemidc");
		MFFSitemsclc = new ItemSecLinkCard(Functions.getItemIdFor("itemsclc", 11118)).a("itemsclc");
		
		if (config != null) {
			config.save();
		}
		
		ModLoader.registerBlock(MFFSMaschines, ItemMachines.class);
		ModLoader.registerBlock(MFFSUpgrades, ItemUpgrades.class);

		ModLoader.registerTileEntity(TileEntityMaschines.class, "Maschines_Multi");
		ModLoader.registerTileEntity(TileEntityGeneratorCore.class, "Generator_Core");
		ModLoader.registerTileEntity(TileEntityAreaProjektor.class, "Area_Projektor");
		ModLoader.registerTileEntity(TileEntityPassivUpgrade.class, "Generator_Upgrade");
		ModLoader.registerTileEntity(TileEntityGeneratorEUInjector.class, "Generator_EU_Injektor");
		ModLoader.registerTileEntity(TileEntityDirectionalProjektor.class, "Directional_Projektor");
		ModLoader.registerTileEntity(TileEntityDeflectorProjektor.class, "Deflector_Projektor");
		ModLoader.registerTileEntity(TileEntityDirectionalExtender.class, "Directional_Extender");
		ModLoader.registerTileEntity(TileEntityTubeProjektor.class, "Tube_Projektor");
		ModLoader.registerTileEntity(TileEntityCamoflageUpgrade.class, "Projektor_camouflage");
		ModLoader.registerTileEntity(TileEntityReaktorField.class, "Reaktor_Field");
		ModLoader.registerTileEntity(TileEntityReaktorConnector.class, "Reactor_Connector");
		ModLoader.registerTileEntity(TileEntityReaktorCooler.class, "Reaktor_Cooler");
		ModLoader.registerTileEntity(TileEntityReaktorMonitor.class, "Reaktor_Monitor");
		ModLoader.registerTileEntity(TileEntityReaktorMonitorClient.class, "Reaktor_Monitor_Client");
		ModLoader.registerTileEntity(TileCamouflagedField.class, "MFFS camo");
		
		ModLoader.addName(MFFSitemMFDidtool, "MFDevice <ID-Tool>");
		ModLoader.addName(MFFSitemMFDwrench, "MFDevice <Wrench>");
		ModLoader.addName(MFFSitemcardempty, oldNames ? "MFFS Card blank " : "Blank MFFS card");
		ModLoader.addName(MFFSitemfc, oldNames ? "MFFS Frequency Card" : "MFFS frequency card");
		ModLoader.addName(MFFSitemidc, oldNames ? "MFFS ID Card" : "MFFS ID card");
		ModLoader.addName(MFFSitemMFDdebugger, "MFDevice <Debugger>");
		ModLoader.addName(MFFSitemsclc, oldNames ? "MFFS  Link Card" : "MFFS link card");
		ModLoader.addName(MFFSitemMFDReaktorlink, oldNames ? "MFFS Remote Reaktor Link" : "MFFS remote reactor link");

		ModLoader.addLocalization("Tube_Projektor.name", oldNames ? "MFFS Tube Projector" : "Tube forcefield projector");
		ModLoader.addLocalization("Directional_Extender.name", "MFFS directional extender");
		ModLoader.addLocalization("Deflector_Projektor.name", "MFFS deflector");
		ModLoader.addLocalization("Generator_Core.name", oldNames ? "MFFS generator core" : "Forcefield core");
		ModLoader.addLocalization("Area_Projektor.name", oldNames ? "MFFS Area Projector" : "MFFS area projector");
		ModLoader.addLocalization("Generator_Storage.name", oldNames ? "MFFS generator storage upgrade" : "Forcefield core storage upgrade");
		ModLoader.addLocalization("Generator_Linkex.name", oldNames ? "MFFS generator range upgrade" : "Forcefield core range upgrade");
		ModLoader.addLocalization("Generator_EU_Injektor.name", oldNames ? "MFFS generator EU-injector" : "Forcefield EU injector");
		ModLoader.addLocalization("Directional_Projektor.name", oldNames ? "MFFS directional projektor" : "Directional forcefield projector");
		ModLoader.addLocalization("Projektor_Subwater.name", oldNames ? "MFFS Projector underwater upgrade" : "Forcefield underwater upgrade");
		ModLoader.addLocalization("Projektor_Dome.name", oldNames ? "MFFS Projector dome upgrade" : "Forcefield dome upgrade");
		ModLoader.addLocalization("Projektor_Hardner.name", oldNames ? "MFFS Projector block cutter upgrade" : "Forcefield block cutter upgrade");
		ModLoader.addLocalization("Projektor_Zapper.name", oldNames ? "MFFS Projector ZAPPER upgrade" : "Forcefield zapper upgrade");
		ModLoader.addLocalization("Projektor_camouflage.name", oldNames ? "MFFS Projector camouflage upgrade" : "Forcefield camouflage upgrade");
		ModLoader.addLocalization("Reaktor_Field.name", oldNames ? "MFFS nuclear reactor containment " : "Reactor containment field projector");
		ModLoader.addLocalization("Reactor_Connector.name", "MFFS reactor connector");
		ModLoader.addLocalization("Reaktor_Cooler.name", "MFFS reactor heat control");
		ModLoader.addLocalization("Reaktor_Monitor.name", "MFFS reactor heat monitor server");
		ModLoader.addLocalization("Reaktor_Monitor_Client.name", "MFFS reactor heat monitor client");
		
		idtotextur.put(new Integer(1), new Integer[] { 17, 17, 17, 17, 17, 17 }); //
		idtotextur.put(new Integer(3), new Integer[] { 18, 18, 18, 18, 18, 18 }); //
		idtotextur.put(new Integer(5), new Integer[] { 20, 20, 20, 20, 20, 20 }); //
		idtotextur.put(new Integer(45), new Integer[] { 23, 23, 23, 23, 23, 23 }); //
		idtotextur.put(new Integer(4), new Integer[] { 32, 32, 32, 32, 32, 32 }); //
		idtotextur.put(new Integer(7), new Integer[] { 33, 33, 33, 33, 33, 33 }); //
		idtotextur.put(new Integer(12), new Integer[] { 34, 34, 34, 34, 34, 34 }); //
		idtotextur.put(new Integer(13), new Integer[] { 35, 35, 35, 35, 35, 35 }); //
		idtotextur.put(new Integer(42), new Integer[] { 38, 38, 38, 38, 38, 38 }); //
		idtotextur.put(new Integer(41), new Integer[] { 39, 39, 39, 39, 39, 39 }); //
		idtotextur.put(new Integer(57), new Integer[] { 40, 40, 40, 40, 40, 40 }); //
		idtotextur.put(new Integer(14), new Integer[] { 48, 48, 48, 48, 48, 48 }); //
		idtotextur.put(new Integer(15), new Integer[] { 49, 49, 49, 49, 49, 49 }); //
		idtotextur.put(new Integer(16), new Integer[] { 50, 50, 50, 50, 50, 50 }); //
		idtotextur.put(new Integer(48), new Integer[] { 52, 52, 52, 52, 52, 52 }); //
		idtotextur.put(new Integer(49), new Integer[] { 53, 53, 53, 53, 53, 53 }); //
		idtotextur.put(new Integer(19), new Integer[] { 64, 64, 64, 64, 64, 64 }); //
		idtotextur.put(new Integer(56), new Integer[] { 66, 66, 66, 66, 66, 66 }); //
		idtotextur.put(new Integer(73), new Integer[] { 67, 67, 67, 67, 67, 67 }); //
		idtotextur.put(new Integer(79), new Integer[] { 83, 83, 83, 83, 83, 83 }); //
		idtotextur.put(new Integer(82), new Integer[] { 88, 88, 88, 88, 88, 88 }); //
		idtotextur.put(new Integer(87), new Integer[] { 30, 30, 30, 30, 30, 30 }); //
		idtotextur.put(new Integer(88), new Integer[] { 31, 31, 31, 31, 31, 31 }); //
		idtotextur.put(new Integer(89), new Integer[] { 44, 44, 44, 44, 44, 44 }); //
		idtotextur.put(new Integer(22), new Integer[] { 85, 85, 85, 85, 85, 85 }); //
		idtotextur.put(new Integer(21), new Integer[] { 71, 71, 71, 71, 71, 71 }); //
		idtotextur.put(new Integer(17), new Integer[] { 37, 37, 36, 36, 36, 36 }); //
		idtotextur.put(new Integer(1017), new Integer[] { 37, 37, 92, 92, 92, 92 }); //
		idtotextur.put(new Integer(2017), new Integer[] { 37, 37, 93, 93, 93, 93 }); //
		idtotextur.put(new Integer(35), new Integer[] { 80, 80, 80, 80, 80, 80 }); //
		idtotextur.put(new Integer(8035), new Integer[] { 81, 81, 81, 81, 81, 81 }); //
		idtotextur.put(new Integer(7035), new Integer[] { 46, 46, 46, 46, 46, 46 }); //
		idtotextur.put(new Integer(15035), new Integer[] { 45, 45, 45, 45, 45, 45 }); //
		idtotextur.put(new Integer(12035), new Integer[] { 72, 72, 72, 72, 72, 72 }); //
		idtotextur.put(new Integer(14035), new Integer[] { 73, 73, 73, 73, 73, 73 }); //
		idtotextur.put(new Integer(2035), new Integer[] { 74, 74, 74, 74, 74, 74 }); //
		idtotextur.put(new Integer(11035), new Integer[] { 69, 69, 69, 69, 69, 69 }); //
		idtotextur.put(new Integer(3035), new Integer[] { 79, 79, 79, 79, 79, 79 }); //
		idtotextur.put(new Integer(13035), new Integer[] { 86, 86, 86, 86, 86, 86 }); //
		idtotextur.put(new Integer(5035), new Integer[] { 87, 87, 87, 87, 87, 87 }); //
		idtotextur.put(new Integer(4035), new Integer[] { 89, 89, 89, 89, 89, 89 }); //
		idtotextur.put(new Integer(10035), new Integer[] { 97, 97, 97, 97, 97, 97 }); //
		idtotextur.put(new Integer(2035), new Integer[] { 98, 98, 98, 98, 98, 98 }); //
		idtotextur.put(new Integer(9035), new Integer[] { 100, 10, 100, 100, 100, 100 }); //
		idtotextur.put(new Integer(1035), new Integer[] { 101, 101, 101, 101, 101, 101 }); //
		idtotextur.put(new Integer(98), new Integer[] { 70, 70, 70, 70, 70, 70 }); //
		idtotextur.put(new Integer(2098), new Integer[] { 28, 28, 28, 28, 28, 28 }); //
		idtotextur.put(new Integer(1098), new Integer[] { 27, 27, 27, 27, 27, 27 }); //
		idtotextur.put(new Integer(20), new Integer[] { 15, 15, 15, 15, 15, 15 }); //
		
		MinecraftForge.setGuiHandler(this, this);
		OneTwoFiveNetworking.initReceive(new PacketMap(), CHANNEL);
	}
	
	@Override
    public void modsLoaded()
    {
    	ExplosionWhitelist.addWhitelistedBlock(MFFSFieldblock);
    	ExplosionWhitelist.addWhitelistedBlock(MFFSUpgrades);
    	ExplosionWhitelist.addWhitelistedBlock(MFFSMaschines);
    	
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 5), new Object[] { " B ", "ACA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("frequencyTransmitter") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 4), new Object[] { "ABA", "BCB", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 1), new Object[] { "BBB", "BCB", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 3), new Object[] { "BAB", "ACA", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 2), new Object[] { "ABA", "ACA", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 6), new Object[] { "ABA", "CDC", "ABA", Character.valueOf('A'), Items.getItem("refinedIronIngot"), Character.valueOf('B'), Items.getItem("insulatedCopperCableItem"), Character.valueOf('C'), Items.getItem("electrolyzedWaterCell"), Character.valueOf('D'), Items.getItem("batBox") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 0), new Object[] { "ABA", "CDC", "AEA", Character.valueOf('A'), Items.getItem("electrolyzedWaterCell"), Character.valueOf('B'), Items.getItem("advancedAlloy"), Character.valueOf('C'), Items.getItem("electronicCircuit"), Character.valueOf('D'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzer") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 4), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 2), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("electronicCircuit") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 3), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("carbonPlate") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 5), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("frequencyTransmitter") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 1), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.BUCKET });
		ModLoader.addRecipe(new ItemStack(MFFSitemMFDwrench), new Object[] { "BCB", "DAD", "DDD", Character.valueOf('A'), Item.DIAMOND, Character.valueOf('B') ,Items.getItem("insulatedCopperCableItem")  , Character.valueOf('C') ,Item.REDSTONE , Character.valueOf('D') ,Items.getItem("refinedIronIngot")  });
		ModLoader.addRecipe(new ItemStack(MFFSitemcardempty), new Object[] { "AAA", "ABA", "AAA", Character.valueOf('A'), Item.PAPER, Character.valueOf('B'), Items.getItem("electronicCircuit") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 6), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("teslaCoil") });
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 7), new Object[] { "BAB", "ACA", "BAB", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('C'), Items.getItem("frequencyTransmitter") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 8), new Object[] { "ACA", "BDB", "ACA", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.REDSTONE, Character.valueOf('C'), Items.getItem("trippleInsulatedIronCableItem"), Character.valueOf('D'), Items.getItem("frequencyTransmitter") });
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 7), new Object[] { "ADA", "BCB", "ABA", Character.valueOf('A'), Items.getItem("carbonPlate"), Character.valueOf('B'), Items.getItem("advancedAlloy"), Character.valueOf('C'), new ItemStack(MFFSMaschines, 1, 1), Character.valueOf('D'), Items.getItem("advancedCircuit") });    	
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 8), new Object[] { "DCD", "CAC", "DBD", Character.valueOf('A'), Items.getItem("advancedMachine"),Character.valueOf('B'), Block.CHEST,Character.valueOf('C'), Items.getItem("integratedHeatDisperser") , Character.valueOf('D'), Items.getItem("advancedAlloy")});    
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 9), new Object[] { "ECE", "DBD", "EAE", Character.valueOf('A'), Items.getItem("advancedMachine"),Character.valueOf('B'), Items.getItem("frequencyTransmitter") , Character.valueOf('C'), Items.getItem("detectorCableItem"), Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('E'), Items.getItem("refinedIronIngot")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 0), new Object[] { "ECE", "DBD", "EAE", Character.valueOf('A'), Items.getItem("machine"),Character.valueOf('B'), Items.getItem("frequencyTransmitter") , Character.valueOf('C'), Item.REDSTONE, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('E'), Items.getItem("refinedIronIngot")});
    	
        ModLoader.addRecipe(new ItemStack(MFFSitemMFDReaktorlink), new Object[] { "DCD", "BAB", "CBC", Character.valueOf('A'), Items.getItem("frequencyTransmitter"), Character.valueOf('B'), Items.getItem("electronicCircuit") , Character.valueOf('C'), Items.getItem("carbonPlate"), Character.valueOf('D'), Item.REDSTONE});
 
        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDwrench), new Object[]{new ItemStack(MFFSitemMFDidtool)});
        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDidtool), new Object[]{new ItemStack(MFFSitemMFDwrench)});
         
    }
	


	public static Object getGuiForId(EntityHuman entityplayer, int i, TileEntity tileentity) {

		int meta = tileentity.world.getData(tileentity.x, tileentity.y, tileentity.z);
		int blockid = tileentity.world.getTypeId(tileentity.x, tileentity.y, tileentity.z);
		if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.id) {
			// TODO WTF?
			i = GUI_ID_GENERATOR;
		}
		
		switch(i) {
		case GUI_ID_GENERATOR:
			return new ContainerGenerator(entityplayer, tileentity == null ? new TileEntityGeneratorCore() : ((TileEntityGeneratorCore) tileentity));
		case GUI_AREA_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityAreaProjektor() : ((TileEntityAreaProjektor) tileentity));
		case GUI_DIRECTIONAL_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityDirectionalProjektor() : ((TileEntityDirectionalProjektor) tileentity));
		case GUI_DEFLECTOR_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityDeflectorProjektor() : ((TileEntityDeflectorProjektor) tileentity));
		case GUI_DIRECTIONAL_UPGRADE:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityDirectionalExtender() : ((TileEntityDirectionalExtender) tileentity));
		case GUI_TUBE_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityTubeProjektor() : ((TileEntityTubeProjektor) tileentity));
		case GUI_CAMOFLAGE_UPGRADE:
			return new ContainerCamoflage(entityplayer, tileentity == null ? new TileEntityCamoflageUpgrade() : ((TileEntityCamoflageUpgrade) tileentity));
		case GUI_REACTOR_FIELD:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityReaktorField() : ((TileEntityReaktorField) tileentity));
		case GUI_REACTOR_COOLER:
			return new ContainerReactorCooler(entityplayer, tileentity == null ? new TileEntityReaktorCooler() : ((TileEntityReaktorCooler) tileentity));
		case GUI_REACTOR_MONITOR:
			return new ContainerReaktorMonitor(entityplayer, tileentity == null ? new TileEntityReaktorMonitor() : ((TileEntityReaktorMonitor) tileentity));
		case GUI_REACTOR_MONITOR_CLIENT:
			return new ContainerReaktorMonitorClient(entityplayer, tileentity == null ? new TileEntityReaktorMonitorClient() : ((TileEntityReaktorMonitorClient) tileentity));
		}
		return null;
	}

	public String getVersion() {
		return ModInfoReader.getModInfoField("/mffs/mod_ModularForceFieldSystem.info.txt", "version");
	}

	@Override
	public Object getGuiElement(int ID, EntityHuman player, World world,
			int x, int y, int z) {
		TileEntity te = world.getTileEntity(x, y, z);
		if(te == null)
			return null;
		return getGuiForId(player, ID, te);
	}

	private static class PacketMap implements IPacketMap {
		@Override
		public IPacket createPacket(byte id) {
			if(id == PKT_GENERIC_UPDATE)
				return new PacketGenericUpdate();
			return null;
		}
	}

}