package mods.immibis.subworlds;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

// maintains a list of fake entities on the client. there is no server equivalent.
// on the server, fake entities are updated and destroyed by whatever created them.
@SideOnly(Side.CLIENT)
public class ClientFakeEntities {
	private static Map<Integer, FakeEntity> ents = new HashMap<Integer, FakeEntity>();
	
	public static void debug(String s) {
		System.out.println("[SubWorlds CFE Debug] "+s);
	}
	
	public static void add(FakeEntity ent) {
		debug("Add CFE "+ent.entityID+": "+ent);
		ents.put(ent.entityID, ent);
	}
	
	public static FakeEntity remove(int entID) {
		debug("Remove CFE "+entID);
		return ents.remove(entID);
	}
	
	public static void reset() {
		debug("Reset CFEs");
		ents.clear();
	}
	
	public static FakeEntity get(int entID) {
		return ents.get(entID);
	}
	
	public static void init() {
		TickRegistry.registerTickHandler(new ClientTickHandler(), Side.CLIENT);
		//TickRegistry.registerTickHandler(new RenderTickHandler(), Side.CLIENT);
		MinecraftForge.EVENT_BUS.register(new EventListener());
	}
	
	private static class ClientTickHandler implements ITickHandler {

		@Override
		public void tickStart(EnumSet<TickType> type, Object... tickData) {
			
		}

		@Override
		public void tickEnd(EnumSet<TickType> type, Object... tickData) {
			for(FakeEntity e : ents.values())
				e.tick();
		}

		@Override
		public EnumSet<TickType> ticks() {
			return EnumSet.of(TickType.CLIENT);
		}

		@Override
		public String getLabel() {
			return "SubWorlds: CFE ticking";
		}
		
	}
	
	// must be public or forge throws errors
	public static class EventListener {
		@ForgeSubscribe
		public void onRWL(RenderWorldLastEvent evt) {
			for(FakeEntity e : ents.values())
				e.renderBase(evt.partialTicks);
		}
	}
}
