package mods.immibis.subworlds;

import java.lang.reflect.Field;

import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetLoginHandler;
import net.minecraft.network.TcpConnection;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.server.MinecraftServer;
import mods.immibis.core.api.porting.SidedProxy;
import mods.immibis.subworlds.dw.DWEntity;
import mods.immibis.subworlds.dw.DWEntityRenderer;
import mods.immibis.subworlds.dw.DWManager;
import mods.immibis.subworlds.mws.MWSManager;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@Mod(version="0.0", dependencies="required-after:ImmibisCore", modid=SubWorldsMod.MODID, name="SubWorlds")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class SubWorldsMod {
	
	public static final String MODID = "SubWorlds";
	
	@Instance(MODID)
	public static SubWorldsMod INSTANCE;
	
	@SideOnly(Side.CLIENT)
	public static class ClientProxy implements IConnectionHandler {
		public ClientProxy() {
			ClientFakeEntities.init();
			NetworkRegistry.instance().registerConnectionHandler(this);
			RenderingRegistry.registerEntityRenderingHandler(DWEntity.class, new DWEntityRenderer());
		}
		
		@Override
		public void clientLoggedIn(NetHandler clientHandler, INetworkManager manager, Packet1Login login) {
			ClientFakeEntities.reset();
		}
		
		@Override public void connectionClosed(INetworkManager manager) {}
		@Override public void connectionOpened(NetHandler netClientHandler, MinecraftServer server, INetworkManager manager) {}
		@Override public void connectionOpened(NetHandler netClientHandler, String server, int port, INetworkManager manager) {}
		@Override public String connectionReceived(NetLoginHandler netHandler, INetworkManager manager) {return null;}
		@Override public void playerLoggedIn(Player player, NetHandler netHandler, INetworkManager manager) {}
	}
	
	@EventHandler
	public void init(FMLInitializationEvent evt) {
		DWManager.init();
		MWSManager.init();
		
		SidedProxy.instance.createSidedObject("mods.immibis.subworlds.SubWorldsMod$ClientProxy", null);
		EntityRegistry.registerModEntity(DWEntity.class, "detachedWorld", 0, this, 200, 5, true);
		
	}
	
	
	private static Field f_sendQueueLength = ReflectionHelper.findField(TcpConnection.class, "field_74489_y", "sendQueueByteLength");
	static {try {f_sendQueueLength.setAccessible(true);} catch(Exception e) {throw new RuntimeException(e);}}
	
	public static boolean sendQueueThrottle(INetworkManager conn) {
		if(!(conn instanceof TcpConnection))
			return false;
		
		try {
			return f_sendQueueLength.getInt(conn) > 1048576;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
}
