package mods.immibis.subworlds.mws;


import java.io.DataInputStream;
import java.io.IOException;

import mods.immibis.subworlds.dw.DWWorldProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class MWSClientWorld extends WorldClient {
	public int dimension;
	
	//private Chunk blankChunk;
	
	public boolean isDead = false;

	public MWSClientWorld(int dimID) {
		// need a valid NetClientHandler for construction so grab one from the real world
		super((NetClientHandler)ReflectionHelper.getPrivateValue(WorldClient.class, Minecraft.getMinecraft().theWorld, 0),
				new WorldSettings(Minecraft.getMinecraft().theWorld.getWorldInfo()),
				dimID,
				0, // difficulty
				Minecraft.getMinecraft().theWorld.theProfiler,
				Minecraft.getMinecraft().theWorld.getWorldLogAgent());
		
		// but now we don't need it any more
		ReflectionHelper.setPrivateValue(WorldClient.class, this, null, 0);
		
		dimension = dimID;
		
		isRemote = true;
		
		Minecraft mc = Minecraft.getMinecraft();
		
		render = new RenderGlobal(mc); /*{
			@Override
			public void renderAllRenderLists(int par1, double par2) {
				super.renderAllRenderLists(par1, par2);
				System.out.println(par1+" "+par2+" "+((java.util.List)ReflectionHelper.getPrivateValue(RenderGlobal.class, this, "glRenderLists")).size());
			}
		};*/
		final EntityRenderer normalER = mc.entityRenderer;
		erender = new EntityRenderer(mc) {
			
			// use the normal lightmap, not our separate one
			@Override public void disableLightmap(double par1) {normalER.disableLightmap(par1);}
			@Override public void enableLightmap(double par1) {normalER.enableLightmap(par1);}
		};
		
		render.setWorldAndLoadRenderers(this);
		
		//blankChunk = getChunkFromChunkCoords(0, 0);
		
		if(provider instanceof DWWorldProvider) {
			DWWorldProvider pv = (DWWorldProvider)provider;
			
			for(int x = -1; x <= pv.props.xsize; x++)
				for(int z = -1; z <= pv.props.zsize; z++)
					doPreChunk(x, z, true);
		}
	}
	
	public RenderGlobal render;
	public EntityRenderer erender;
	
	public void receiveWorldUpdate(DataInputStream in) throws IOException {
		int minx, miny, minz, maxx, maxy, maxz;
		if(in.readByte() == 1) {
			minx = in.readInt();
			miny = in.readByte() & 255;
			minz = in.readInt();
			maxx = in.readInt();
			maxy = in.readByte() & 255;
			maxz = in.readInt();
		} else {
			minx = maxx = in.readInt();
			miny = maxy = in.readByte() & 255;
			minz = maxz = in.readInt();
		}
		System.out.println(minx+" "+miny+" "+minz+" "+maxx+" "+maxy+" "+maxz);
		for(int x = minx; x <= maxx; x++)
		for(int y = miny; y <= maxy; y++)
		for(int z = minz; z <= maxz; z++) {
			Chunk c = getChunkFromBlockCoords(x, z);
			
			int id = in.readByte() & 255;
			if((id & 128) != 0) {
				id = ((id & 127) << 8) | (in.readByte() & 255); 
			}
			
			int meta = (id == 0 ? 0 : in.readByte() & 15);
			
			//System.out.println(x+" "+y+" "+z+" "+id+" "+meta);
			
			c.setBlockIDWithMetadata(x&15, y, z&15, id, meta);
				
			int lv = in.readByte();
			c.setLightValue(EnumSkyBlock.Block, x&15, y, z&15, (lv >> 4) & 15);
			c.setLightValue(EnumSkyBlock.Sky, x&15, y, z&15, lv & 15);
		}
		
		int nDescPackets = in.readInt();
		if(nDescPackets > 0) {
			Minecraft mc = Minecraft.getMinecraft();
			WorldClient realWorld = mc.theWorld;
			mc.theWorld = this;
			
			for(int k = 0; k < nDescPackets; k++) {
				int id = in.readByte() & 255;
				int size = in.readByte();
				int expectedLeft = in.available() - size;
				
				Packet p = Packet.getNewPacket(getWorldLogAgent(), id);
				p.readPacketData(in);
				
				if(in.available() != expectedLeft)
					System.out.println("Warning: Packet size mismatch for packet type #"+id);
				
				p.processPacket(mc.thePlayer.sendQueue);
			}
			
			mc.theWorld = realWorld;
		}
	}

	public void zeppelinTick() {
		updateEntities();
	}

	public void unloadChunk(int x, int z) {
		doPreChunk(x, z, false);
	}
}
