package mods.immibis.subworlds.mws.packets;


import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import mods.immibis.core.ImmibisCore;
import mods.immibis.core.api.net.IPacket;
import mods.immibis.subworlds.mws.MWSManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;

public class PacketMWSTile implements IPacket {
	
	public Packet desc;
	public int dim;
	
	public PacketMWSTile() {}

	public PacketMWSTile(World w, Packet teDesc) {
		desc = teDesc;
		dim = w.provider.dimensionId;
	}

	@Override
	public byte getID() {
		return MWSManager.PKT_TILE;
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeInt(dim);
		out.writeByte(desc.getPacketId());
		desc.writePacketData(out);
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		dim = in.readInt();
		
		int id = in.readByte() & 255;
		desc = Packet.getNewPacket(ImmibisCore.getLogAgent(), id);
		if(desc == null) {
			System.err.println("[Zeppelin 2] Invalid tile description packet ID: "+id);
		} else
			desc.readPacketData(in);
	}

	@Override
	public String getChannel() {
		return MWSManager.CHANNEL;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void onReceived(EntityPlayer source) {
		WorldClient w = MWSManager.getClientWorld(dim);
		if(w != null) {
			Minecraft mc = Minecraft.getMinecraft();
			WorldClient oldWorld = mc.theWorld;
			
			mc.theWorld = w;
			desc.processPacket(mc.thePlayer.sendQueue);
			mc.theWorld = oldWorld;
		}
	}

}
