package mods.immibis.tinycarts;

import java.util.Collections;
import java.util.List;

import org.bouncycastle.util.Arrays;

import mods.immibis.subworlds.dw.DWWorldProvider;
import mods.immibis.subworlds.dw.WorldProps;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class InteriorChunkGen implements IChunkProvider {

	private WorldProps props;
	private WorldServer w;
	
	public InteriorChunkGen(WorldServer w, DWWorldProvider wp) {
		this.props = wp.props;
		this.w = w;
	}
	
	@Override
	public Chunk provideChunk(int i, int j) {
		Chunk c = new Chunk(w, i, j);
		
		BlockTransparentBedrock.allowPlacement.incrementAndGet();
		
		try {
			if(i == 0 && j == 0) {
				for(int x = 0; x < props.xsize; x++)
					for(int z = 0; z < props.zsize; z++) {
						c.setBlockIDWithMetadata(x, 0, z, TinyCartsMod.transparentBedrock.blockID, 0);
						c.setBlockIDWithMetadata(x, props.ysize-1, z, TinyCartsMod.transparentBedrock.blockID, 0);
						c.setBlockIDWithMetadata(x, 1, z, Block.planks.blockID, 0);
					}
				
				for(int x = 0; x < props.xsize; x++)
					for(int y = 0; y < props.ysize; y++) {
						c.setBlockIDWithMetadata(x, y, 0, TinyCartsMod.transparentBedrock.blockID, 0);
						c.setBlockIDWithMetadata(x, y, props.zsize-1, TinyCartsMod.transparentBedrock.blockID, 0);
						c.setBlockIDWithMetadata(0, y, x, TinyCartsMod.transparentBedrock.blockID, 0);
						c.setBlockIDWithMetadata(props.xsize-1, y, x, TinyCartsMod.transparentBedrock.blockID, 0);
					}
			}
		} finally {
			BlockTransparentBedrock.allowPlacement.decrementAndGet();
		}
		
		c.generateSkylightMap();
        Arrays.fill(c.getBiomeArray(), (byte)BiomeGenBase.plains.biomeID);
        c.isTerrainPopulated = true;
		
		return c;
	}

	@Override
	public boolean chunkExists(int i, int j) {
		return true;
	}

	@Override
	public Chunk loadChunk(int i, int j) {
		return provideChunk(i, j);
	}

	@Override
	public void populate(IChunkProvider ichunkprovider, int i, int j) {
		
	}

	@Override
	public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
		return true;
	}

	@Override
	public boolean unloadQueuedChunks() {
		return false;
	}

	@Override
	public boolean canSave() {
		return true;
	}

	@Override
	public String makeString() {
		return getClass().getName();
	}

	@Override
	public List<?> getPossibleCreatures(EnumCreatureType enumcreaturetype, int i, int j, int k) {
		return Collections.EMPTY_LIST;
	}

	@Override
	public ChunkPosition findClosestStructure(World world, String s, int i, int j, int k) {
		return null;
	}

	@Override
	public int getLoadedChunkCount() {
		return 0;
	}

	@Override
	public void recreateStructures(int i, int j) {
	}

	@Override
	public void saveExtraData() {
	}
}
