package mods.immibis.tinycarts;

import cpw.mods.fml.common.registry.LanguageRegistry;
import mods.immibis.subworlds.dw.DWWorldProvider;
import net.minecraft.block.BlockRailBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.World;

public class ItemMinecartAwesome extends Item {
    public ItemMinecartAwesome(int par1)
    {
        super(par1);
        this.maxStackSize = 1;
        
        this.setCreativeTab(CreativeTabs.tabTransport);
        this.setTextureName("tinycarts:minecart");
        this.setUnlocalizedName("tinycarts:awesome-cart");
        LanguageRegistry.addName(this, "Expansible Minecart");
    }

    /**
     * Callback for item usage. If the item does something special on right clicking, he will have one of those. Return
     * True if something happen and false if it don't. This is for ITEMS, not BLOCKS
     */
    @Override
	public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10)
    {
    	if(par3World.provider instanceof DWWorldProvider) {
    		if(par3World.isRemote)
    			par2EntityPlayer.sendChatToPlayer(ChatMessageComponent.createFromText("Don't even think about it."));
    		return false;
    	}

        int i1 = par3World.getBlockId(par4, par5, par6);

        if (BlockRailBase.isRailBlock(i1))
        {
            if (!par3World.isRemote)
            {
                EntityMinecart entityminecart = new EntityMinecartAwesome(par3World, (double)((float)par4 + 0.5F), (double)((float)par5 + 0.5F), (double)((float)par6 + 0.5F));

                if (par1ItemStack.hasDisplayName())
                {
                    entityminecart.setMinecartName(par1ItemStack.getDisplayName());
                }

                par3World.spawnEntityInWorld(entityminecart);
            }

            --par1ItemStack.stackSize;
            return true;
        }
        else
        {
            return false;
        }
    }
}
