package immibis.tubestuff;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;

import net.minecraft.src.ContainerChest;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import immibis.core.BasicInventory;
import immibis.core.NonSharedProxy;
import immibis.core.TileBasicInventory;
import immibis.core.TileCombined;

public class TileBuffer extends TileBasicInventory implements IPeripheral {

	public static final int INVSIZE = 18;
	
	public TileBuffer() {
		super(INVSIZE, "Buffer");
	}
	
	private transient LinkedList<IComputerAccess> notify = new LinkedList<IComputerAccess>();
	private boolean override = false;
	
	private int overrideEmitSlot = -1;
	private IComputerAccess overrideEmitPing;
	private static int overrideEmitNextToken = 0;
	private int overrideEmitToken;

	private int update_ticks = 0;
	private boolean inv_empty = false;
	private boolean find_pipe = true;
	private TileEntity out_pipe = null;
	private int delay = 20;
	
	private static final int MIN_DELAY = 10;
	private static final int MAX_DELAY = 100;
	
	private static Class class_PipeTransportItems = null, class_EntityPassiveItem = null, enum_Orientations = null, class_TileGenericPipe = null;
	private static Class class_Pipe = null;
	private static Constructor cons_EntityPassiveItem = null;
	private static Method meth_entityEntering = null;
	private static Field field_transport = null, field_pipe = null;
	
	private Object getBCDir(String name) {
		try {
			return enum_Orientations.getField(name).get(null);
		} catch(Exception e) {
			return null;
		}
	}
	
	private boolean enterPipe(ItemStack stack) {
		if(out_pipe == null)
			return true;
		
		try {
			Object dir = null;
			if(out_pipe.xCoord < xCoord)
				dir = getBCDir("XNeg");
			else if(out_pipe.xCoord > xCoord)
				dir = getBCDir("XPos");
			else if(out_pipe.yCoord < yCoord)
				dir = getBCDir("YNeg");
			else if(out_pipe.yCoord > yCoord)
				dir = getBCDir("YPos");
			else if(out_pipe.zCoord < zCoord)
				dir = getBCDir("ZNeg");
			else if(out_pipe.zCoord > zCoord)
				dir = getBCDir("ZPos");
			Object item = cons_EntityPassiveItem.newInstance(worldObj, (double)(xCoord + out_pipe.xCoord + 1)/2, (double)(yCoord + out_pipe.yCoord)/2, (double)(zCoord + out_pipe.zCoord + 1)/2, stack);
			meth_entityEntering.invoke(field_transport.get(field_pipe.get(out_pipe)), item, dir);
		} catch (Exception e) {
			e.printStackTrace();
			out_pipe = null;
			return false;
		}
		return true;
	}
	
	static {
		try {
			ClassLoader cl = TileBuffer.class.getClassLoader();
			class_PipeTransportItems = cl.loadClass("buildcraft.transport.PipeTransportItems");
			class_Pipe = cl.loadClass("buildcraft.transport.Pipe");
			class_EntityPassiveItem = cl.loadClass("buildcraft.api.EntityPassiveItem");
			enum_Orientations = cl.loadClass("buildcraft.api.Orientations");
			class_TileGenericPipe = cl.loadClass("buildcraft.transport.TileGenericPipe");
			cons_EntityPassiveItem = class_EntityPassiveItem.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, ItemStack.class);
			meth_entityEntering = class_PipeTransportItems.getMethod("entityEntering", new Class[] {class_EntityPassiveItem, enum_Orientations});
			field_pipe = class_TileGenericPipe.getField("pipe");
			field_transport = class_Pipe.getField("transport");
		} catch (Exception e) {
			ModLoader.getLogger().info("Could not access BuildCraft for buffer output because:");
			ModLoader.getLogger().info(e.getClass().getName()+": "+e.getMessage());
			
			class_PipeTransportItems = null;
			class_Pipe = null;
			class_EntityPassiveItem = null;
			enum_Orientations = null;
			class_TileGenericPipe = null;
			cons_EntityPassiveItem = null;
			meth_entityEntering = null;
			field_pipe = null;
			field_transport = null;
		}
	}
	
	private void checkPipe(TileEntity te)
	{
		if(te != null && out_pipe == null && te.getClass().getName().equals("buildcraft.transport.TileGenericPipe"))
		{
			try
			{
				String pipeclass = field_pipe.get(te).getClass().getName();
				if(pipeclass.equals("buildcraft.transport.pipes.PipeItemsWood")
				|| pipeclass.equals("buildcraft.transport.pipes.PipeItemsGold")
				|| pipeclass.equals("buildcraft.krapht.pipes.PipeItemsBasicLogistics"))
					out_pipe = te;
			} catch(Exception e) {
			}
		}
	}

	@Override
	public void updateEntity() {
		if(inv_empty || worldObj.isRemote)
			return;
		if(++update_ticks < delay)
		{
			if(update_ticks > 2 && redstone_output)
			{
				redstone_output = false;
				notifyNeighbouringBlocks();
				if(override && overrideEmitPing != null)
				{
					overrideEmitPing.queueEvent("immibis.tubestuff.buffer.emitStackDone", new Object[] {overrideEmitToken});
					overrideEmitPing = null;
				}
			}
			return;
		}
		update_ticks = 0;
		
		// find largest stack
		int best = 0;
		ItemStack[] contents = inv.contents;
		if(override)
		{
			if(overrideEmitSlot != -1)
			{
				best = overrideEmitSlot;
				overrideEmitSlot = -1;
			}
			else
				return;
		}
		else
		{
			int best_size = 0;
			int worst = 0;
			int worst_size = 64;
			int used = 0;
			for(int k = 0; k < INVSIZE; k++)
			{
				if(contents[k] == null)
					continue;
				++used;
				if(contents[k].stackSize > best_size)
				{
					best_size = contents[k].stackSize;
					best = k;
				}
				if(contents[k].stackSize < worst_size)
				{
					worst_size = contents[k].stackSize;
					worst = k;
				}
			}
			
			if(best_size == 0 || used == 0)
			{
				inv_empty = true;
				return;
			}
			
			delay = MAX_DELAY + (int)((MIN_DELAY - MAX_DELAY) * (used / (double)INVSIZE));
			
			if(best_size < contents[best].getMaxStackSize() / 2)
			{
				best_size = worst_size;
				best = worst;
			}
		}
		
		if(best != 0)
		{
			// put it in the first slot so filters will grab it first
			ItemStack temp = contents[best];
			contents[best] = contents[0];
			contents[0] = temp;
			onInventoryChanged();
			
			for(IComputerAccess ica : notify)
				ica.queueEvent("immibis.tubestuff.buffer.notify", new Object[] {contents[0].itemID, contents[0].stackSize, contents[0].getItemDamage()});
		}
		
		if(find_pipe)
		{
			out_pipe = null;
			
			checkPipe(worldObj.getBlockTileEntity(xCoord-1, yCoord, zCoord));
			checkPipe(worldObj.getBlockTileEntity(xCoord+1, yCoord, zCoord));
			checkPipe(worldObj.getBlockTileEntity(xCoord, yCoord-1, zCoord));
			checkPipe(worldObj.getBlockTileEntity(xCoord, yCoord+1, zCoord));
			checkPipe(worldObj.getBlockTileEntity(xCoord, yCoord, zCoord-1));
			checkPipe(worldObj.getBlockTileEntity(xCoord, yCoord, zCoord+1));
			
			find_pipe = false;
		}
		
		if(out_pipe != null)
		{
			if(contents[0] != null)
			{
				if(enterPipe(contents[0]))
				{
					contents[0] = null;
					onInventoryChanged();
				}
				else
					out_pipe = null;
			}
		}
		else if(!redstone_output)
		{
			redstone_output = true;
			notifyNeighbouringBlocks();
		}
	}
	
	@Override
	public void onBlockNeighbourChange() {
		find_pipe = true;
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		player.openGui(mod_TubeStuff.instance, mod_TubeStuff.GUI_BUFFER, worldObj, xCoord, yCoord, zCoord);
		return true;
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack)
    {
        super.setInventorySlotContents(i, itemstack);
        inv_empty = false;
    }
	
	@Override
	public void writeToNBT(NBTTagCompound nbt)
	{
		super.writeToNBT(nbt);
		nbt.setBoolean("override", override);
	}
	
	
	
	
	
	
	
	
	/*
	 *
	 * getItemID(slot)
	 * getQuantity(slot)
	 * getDamage(slot)
	 * moveItems(src, dst, qty) -- errors if moveItems is off
	 * emitStack(slot) -- errors if override is off
	 * setOverride(flag)
	 * getOverride()
	 * setNotify(flag)
	 * getNotify()
	 * 
	 * When saving, override is set if notify is set, then notify is cleared. (NOT YET)
	 * You must re-set notify then clear override.
	 * 
	 * Detaching a computer clears override and notify (even if multiple computers are connected)
	 * 
	 */

	@Override
	public String[] getMethodNames() {
		return new String[] {"getItemID", "getQuantity", "getDamage",
				"moveItems", "emitStack",
				"setOverride", "getOverride", "setNotify", "getNotify"
		};
	}

	@Override
	public Object[] callMethod(IComputerAccess icomputeraccess, int i,
			Object[] aobj) throws Exception {
		switch(i)
		{
		case 0: // getItemID
		case 1: // getQuantity
		case 2: // getDamage
			if(!SharedProxy.CC_CheckArgs(aobj, new Class[] {Double.class}))
				return new Object[] {false, "Wrong arguments"};
			{
				int s = (int)(double)(Double)aobj[0];
				if(s < 0 || s >= getSizeInventory())
					return new Object[] {false, "Slot number out of range"};
				ItemStack is = getStackInSlot(s);
				if(is == null)
					return new Object[] {true, 0};
				return new Object[] {true, (i == 0 ? is.itemID : i == 1 ? is.stackSize : is.getItemDamage())};
			}
		
		case 3: // moveItems
			if(!override)
				return new Object[] {false, "Not in override mode"};
			if(!SharedProxy.CC_CheckArgs(aobj, new Class[] {Double.class, Double.class, Double.class}))
				return new Object[] {false, "Wrong arguments"};
			{
				int src = (int)(double)(Double)aobj[0];
				int dst = (int)(double)(Double)aobj[1];
				int qty = (int)(double)(Double)aobj[2];
				
				if(src < 0 || dst < 0 || src >= getSizeInventory() || dst >= getSizeInventory())
					return new Object[] {false, "Slot number out of range"};
				if(src == dst)
					return new Object[] {false, "Source and destination are the same"};
				
				ItemStack si = getStackInSlot(src), di = getStackInSlot(dst);
				if(si == null || si.stackSize < qty)
					return new Object[] {false, "Insufficient items in source slot"};
				if(di != null && (di.itemID != si.itemID || di.getItemDamage() != si.getItemDamage()))
					return new Object[] {false, "Cannot stack different items"};
				if(di.stackSize + qty > di.getMaxStackSize())
					return new Object[] {false, "Would exceed maximum stack size"};
				return new Object[] {true};
			}
			
		case 4: // emitStack
			if(!override)
				return new Object[] {false, "Not in override mode"};
			if(!SharedProxy.CC_CheckArgs(aobj, new Class[] {Double.class}))
				return new Object[] {false, "Wrong arguments"};
			{
				int slot = (int)(double)(Double)aobj[0];
				if(overrideEmitSlot != -1)
					return new Object[] {false, "busy"};
				overrideEmitToken = overrideEmitNextToken++;
				overrideEmitPing = icomputeraccess;
				overrideEmitSlot = slot;
				delay = 20;
				return new Object[] {true, overrideEmitToken};
			}
		
		case 5: // setOverride
		case 7: // setNotify
			if(!SharedProxy.CC_CheckArgs(aobj, new Class[] {Boolean.class}))
				return new Object[] {false, "Wrong arguments"};
			{
				boolean b = ((Boolean)aobj[0]).booleanValue();
				if(i == 5) // setOverride
				{
					override = b;
					if(!b)
						update_ticks = delay; // force immediate update
				}
				else // setNotify
				{
					if(b)
					{
						if(!notify.contains(icomputeraccess))
							notify.add(icomputeraccess);
					}
					else
						notify.remove(icomputeraccess);
				}
			}
			return new Object[] {true};
			
		case 6: // getOverride
			return new Object[] {override};
		case 8: // getNotify
			return new Object[] {notify.contains(icomputeraccess)};
		}
		return new Object[] {false, "Invalid method index"};
	}

	@Override
	public String getType() {
		return "immibis.tubestuff.buffer";
	}

	@Override
	public void attach(IComputerAccess icomputeraccess, String s) {
	}

	@Override
	public void detach(IComputerAccess icomputeraccess) {
		notify.remove(icomputeraccess);
		if(notify.size() == 0)
			override = false;
	}

	@Override
	public boolean canAttachToSide(int side) {
		return true;
	}
}
