package immibis.ars;

import ic2.api.ExplosionWhitelist;
import ic2.api.Items;
import immibis.ars.beams.*;
import immibis.ars.packet.PacketGenericUpdate;
import immibis.ars.projectors.TileProjector;
import immibis.ars.projectors.TileProjectorArea;
import immibis.ars.projectors.TileProjectorDeflector;
import immibis.ars.projectors.TileProjectorDirectional;
import immibis.ars.projectors.TileProjectorExtender;
import immibis.ars.projectors.TileProjectorReactor;
import immibis.ars.projectors.TileProjectorTube;
import immibis.core.api.APILocator;
import immibis.core.api.FMLModInfo;
import immibis.core.api.net.IPacket;
import immibis.core.api.net.IPacketMap;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.SidedProxy;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
//import org.lwjgl.input.Keyboard;
//import net.minecraft.client.Minecraft;

@Mod(version = "52.0.2", name = "Advanced Repulsion Systems", modid = "AdvancedRepulsionSystems", dependencies = "required-after:ImmibisCore;required-after:IC2")
@NetworkMod(clientSideRequired = false, serverSideRequired = true)
@FMLModInfo(
	url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
	description="Adds FORCEFIELDS!",
	credits="Originally by Thunderdark, updated by immibis. Some textures by kaj_ and IvySaur1996.",
	authors="Thunderdark;immibis"
	)
public class ARSMod extends PortableBaseMod implements IPacketMap {

	@cpw.mods.fml.common.SidedProxy(clientSide="immibis.ars.ClientProxy", serverSide="immibis.ars.BaseProxy")
	public static BaseProxy proxy;

	public static Configuration config;

	public static Block MFFSMaschines;
	public static Block MFFSUpgrades;
	public static Block MFFSFieldblock;

	public static Item MFFSitemMFDwrench;
	public static Item MFFSitemMFDoffset;
	public static Item MFFSitemMFDdebugger;
	public static Item MFFSitemcardempty;
	public static Item MFFSitemfc;
	public static Item MFFSitemsclc;
	public static Item itemComponent;

	public static final int GUI_ID_GENERATOR = 1;
	public static final int GUI_AREA_PROJECTOR = 2;
	public static final int GUI_DIRECTIONAL_PROJECTOR = 3;
	public static final int GUI_DEFLECTOR_PROJECTOR = 4;
	public static final int GUI_DIRECTIONAL_UPGRADE = 5;
	public static final int GUI_TUBE_PROJECTOR = 6;
	public static final int GUI_CAMOFLAGE_UPGRADE = 7;
	public static final int GUI_REACTOR_FIELD = 8;
	public static final int GUI_REACTOR_COOLER = 9;
	public static final int GUI_REACTOR_MONITOR = 10;
	public static final int GUI_REACTOR_MONITOR_CLIENT = 11;
	public static final int GUI_REACTOR_MONITOR_REMOTE = 12;
	public static final int GUI_UPGRADE_UNIT = 13;
	public static final int GUI_LOOT_COLLECTOR = 14;
	public static final int GUI_INVENTORY_CONTENTS_FILTER = 15;
	public static final int GUI_POTION_UPGRADE = 16;

	public static final String CHANNEL = "AdvRepSys";

	public static final byte PKT_GENERIC_UPDATE = 0;
	public static final byte PKT_PROJECTOR_DESCRIPTION = 1; // unused
	public static final byte PKT_BOLT_FX = 2;

	public static final boolean DEBUG_MODE = Block.class.getName().equals("net.minecraft.src.Block");

	// begin config options
	public static int forcefieldblockcost;
	public static int forcefieldblockcreatemodifier;
	public static int forcefieldblockzappermodifier;

	public static int reaktorheatcontrolice;
	public static int reaktorheatcontrolwater;
	public static int reaktorheatcontrollava;

	public static int core_storage_default;
	public static int core_storage_upgrade_amount;
	public static int core_range_default;
	//public static int core_range_upgrade_amount;

	public static boolean enableReactorBlocks, enableTeslaCoil;
	public static boolean useOldRecipes;
	// end config options

	public static StringBuffer hasher = new StringBuffer();
	public static Map<Integer, int[]> idtotextur = new HashMap<Integer, int[]>();

	public static ARSMod instance;

	public static int maxCamoBlockId;

	public static boolean slowRefresh;
	public static int maxSize, maxDeflectorDistance, maxTubeRadius;
	public static int refreshSpeed;

	public ARSMod() {
		instance = this;
	}

	@Init
	public void load(FMLInitializationEvent evt) {
		config = new Configuration(new File(Functions.getMinecraftDir(), "/config/AdvancedRepulsionSystems.cfg"));
		config.load();

		BlockForceField.model = SidedProxy.instance.getUniqueBlockModelID("immibis.ars.BlockRendererField", true);

		/*Property slowRefreshProp = config.getOrCreateBooleanProperty("slowRefresh", Configuration.CATEGORY_GENERAL, false);
		slowRefreshProp.comment = "If true, forcefields will refresh every second. If false every tick (as before).";
		slowRefresh = Boolean.valueOf(slowRefreshProp.value);*/
		slowRefresh = false;

		Functions.removeIntFromBlockSection("reaktorheatcontrolice");
		Functions.removeIntFromBlockSection("reaktorheatcontrolwater");
		Functions.removeIntFromBlockSection("reaktorheatcontrollava");

		forcefieldblockcost = Functions.getIntFromBlockSection("forcefieldblockcost", "fieldCostBase", 1);
		forcefieldblockcreatemodifier = Functions.getIntFromBlockSection("forcefieldblockcreatemodifier", "fieldCostCreateMultiplier", 10);
		forcefieldblockzappermodifier = Functions.getIntFromBlockSection("forcefieldblockzappermodifier", "fieldCostZapperMultiplier", 2);
		maxSize = Functions.getBalanceOption("maxProjectorSize", 32);
		maxDeflectorDistance = Functions.getBalanceOption("maxDeflectorDistance", 10);
		maxTubeRadius = Functions.getBalanceOption("maxTubeRadius", 5);
		refreshSpeed = Functions.getBalanceOption("refreshSpeed", 100);
		TileProjector.maxOffset = Functions.getBalanceOption("maxOffset", 48);
		TileProjector.cooldownBlocksPerTick = Functions.getBalanceOption("cooldownBlocksPerTick", 40);

		enableReactorBlocks = Functions.getConfigBoolean("enableReactorBlocks", true);
		enableTeslaCoil = Functions.getConfigBoolean("enableTeslaCoil", true);
		useOldRecipes = Functions.getConfigBoolean("useOldRecipes", false);

		core_range_default = Functions.getBalanceOption("coreRangeDefault", 16);
		core_storage_default = Functions.getBalanceOption("coreStorageDefault", 1000000);
		//core_range_upgrade_amount = Functions.getBalanceOption("coreRangeUpgradeAmount", )
		core_storage_upgrade_amount = Functions.getBalanceOption("coreStorageUpgradeAmount", 2000000);

		int fieldBlockID = Functions.getActualBlockIdFor("HFFPFieldblock", "blockField", 255);
		int machineID = Functions.getActualBlockIdFor("HFFPMaschines", "blockMachine", 253);
		int upgradeID = Functions.getActualBlockIdFor("HFFSUpgrades", "blockUpgrade", 254);
		int debuggerID = Functions.getItemIdFor("itemMFDdebugger", "itemDebuggerMFD", 11111);
		int wrenchID = Functions.getItemIdFor("itemMFDwrench", "itemWrenchMFD", 11114);
		int emptyCardID = Functions.getItemIdFor("itemcardempty", "itemCardEmpty", 11115);
		int freqCardID = Functions.getItemIdFor("itemfc", "itemCardCoreLink", 11116);
		int reactorCardID = Functions.getItemIdFor("itemsclc", "itemCardReactorLink", 11118);
		int offsetID = Functions.getItemIdFor("itemMFDoffset", "itemOffsetMFD", 11119);
		int componentID = Functions.getItemIdFor("itemComponent", "itemCraftingComponent", 11121);

		if(enableTeslaCoil)
			BeamsMain.readConfig();

		config.save();

		MFFSFieldblock = new BlockForceField(fieldBlockID);
		MFFSMaschines = new BlockMachine(machineID);
		MFFSUpgrades = new BlockUpgrades(upgradeID);

		MFFSitemMFDdebugger = new ItemMFD_debuger(debuggerID - 256).setItemName("itemMFDdebugger");
		MFFSitemMFDwrench = new ItemMFD_wrench(wrenchID - 256).setItemName("itemMFDwrench");
		MFFSitemcardempty = new ItemCardempty(emptyCardID - 256).setItemName("itemcardempty");
		MFFSitemfc = new ItemFrequenzCard(freqCardID - 256).setItemName("itemfc");
		MFFSitemsclc = new ItemSecLinkCard(reactorCardID - 256).setItemName("itemsclc");
		MFFSitemMFDoffset = new ItemMFD_offset(offsetID - 256).setItemName("itemMFDoffset");
		// 11120 is logic cards
		itemComponent = new ItemComponent(componentID - 256);

		if(enableTeslaCoil)
			BeamsMain.init();

		if (config != null) {
			config.save();
		}

		ModLoader.registerBlock(MFFSMaschines, ItemMachines.class);
		ModLoader.registerBlock(MFFSUpgrades, ItemUpgrades.class);
		ModLoader.registerBlock(MFFSFieldblock);

		ModLoader.registerTileEntity(TileEntityMaschines.class, "Maschines_Multi");
		ModLoader.registerTileEntity(TileEntityGeneratorCore.class, "Generator_Core");
		ModLoader.registerTileEntity(TileProjectorArea.class, "Area_Projektor");
		ModLoader.registerTileEntity(TileUpgradePassive.class, "Generator_Upgrade");
		ModLoader.registerTileEntity(TileEntityGeneratorEUInjector.class, "Generator_EU_Injektor");
		ModLoader.registerTileEntity(TileProjectorDirectional.class, "Directional_Projektor");
		ModLoader.registerTileEntity(TileProjectorDeflector.class, "Deflector_Projektor");
		ModLoader.registerTileEntity(TileProjectorExtender.class, "Directional_Extender");
		ModLoader.registerTileEntity(TileProjectorTube.class, "Tube_Projektor");
		ModLoader.registerTileEntity(TileUpgradeCamouflage.class, "Projektor_camouflage");
		ModLoader.registerTileEntity(TileProjectorReactor.class, "Reaktor_Field");
		ModLoader.registerTileEntity(TileEntityReaktorConnector.class, "Reactor_Connector");
		ModLoader.registerTileEntity(TileEntityReaktorCooler.class, "Reaktor_Cooler");
		ModLoader.registerTileEntity(TileEntityReaktorMonitor.class, "Reaktor_Monitor");
		ModLoader.registerTileEntity(TileEntityReaktorMonitorClient.class, "Reaktor_Monitor_Client");
		ModLoader.registerTileEntity(TileCamouflagedField.class, "MFFS camo");

		ModLoader.addName(MFFSitemMFDwrench, "MFDevice <Wrench>");
		ModLoader.addName(MFFSitemcardempty, "Blank ARS card");
		ModLoader.addName(MFFSitemfc, "Forcefield frequency card");
		ModLoader.addName(MFFSitemMFDdebugger, "MFDevice <Debugger>");
		ModLoader.addName(MFFSitemsclc, "ARS reactor link card");
		ModLoader.addName(MFFSitemMFDoffset, "MFDevice <Offset>");

		ModLoader.addLocalization("Tube_Projektor.name", "Tube forcefield projector");
		ModLoader.addLocalization("Directional_Extender.name", "Line projector extender");
		ModLoader.addLocalization("Deflector_Projektor.name", "Plate forcefield projector");
		ModLoader.addLocalization("Generator_Core.name", "Forcefield core");
		ModLoader.addLocalization("Area_Projektor.name", "Area forcefield projector");
		ModLoader.addLocalization("Generator_Storage.name", "Forcefield core storage upgrade");
		ModLoader.addLocalization("Generator_Linkex.name", "Forcefield core range upgrade");
		ModLoader.addLocalization("Generator_EU_Injektor.name", "Forcefield EU injector");
		ModLoader.addLocalization("Directional_Projektor.name", "Directional forcefield projector");
		ModLoader.addLocalization("Projektor_Subwater.name", "Forcefield underwater upgrade");
		ModLoader.addLocalization("Projektor_Dome.name", "Forcefield dome upgrade");
		ModLoader.addLocalization("Projektor_Hardner.name", "Forcefield block cutter upgrade");
		ModLoader.addLocalization("Projektor_Zapper.name", "Forcefield zapper upgrade");
		ModLoader.addLocalization("Projektor_camouflage.name", "Forcefield camouflage upgrade");
		ModLoader.addLocalization("Reaktor_Field.name", "Reactor containment field projector");
		ModLoader.addLocalization("Reactor_Connector.name", "Reactor connector");
		ModLoader.addLocalization("Reaktor_Cooler.name", "Reactor coolant injector");
		ModLoader.addLocalization("Reaktor_Monitor.name", "Reactor heat monitor server");
		ModLoader.addLocalization("Reaktor_Monitor_Client.name", "Reactor heat monitor client");
		ModLoader.addLocalization("MFFS_Inhibitor.name", "Forcefield inhibitor upgrade");

		SidedProxy.instance.preloadTexture("/immibis/ars/textures/upgrades.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/machines.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/blocks.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/items.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/world-kaj.png");

		addCamoBlock(Block.stone, 0);
		addCamoBlock(Block.grass, 0);
		addCamoBlock(Block.dirt, 0);
		addCamoBlock(Block.cobblestone, 0);
		addCamoBlock(Block.planks, 0);
		addCamoBlock(Block.planks, 1);
		addCamoBlock(Block.planks, 2);
		addCamoBlock(Block.planks, 3);
		addCamoBlock(Block.bedrock, 0);
		addCamoBlock(Block.sand, 0);
		addCamoBlock(Block.gravel, 0);
		addCamoBlock(Block.oreGold, 0);
		addCamoBlock(Block.oreIron, 0);
		addCamoBlock(Block.oreCoal, 0);
		addCamoBlock(Block.wood, 0);
		addCamoBlock(Block.wood, 1);
		addCamoBlock(Block.wood, 2);
		addCamoBlock(Block.wood, 3);
		addCamoBlock(Block.leaves, 0);
		addCamoBlock(Block.leaves, 1);
		addCamoBlock(Block.leaves, 2);
		addCamoBlock(Block.leaves, 3);
		addCamoBlock(Block.sponge, 0);
		addCamoBlock(Block.glass, 0);
		addCamoBlock(Block.oreLapis, 0);
		addCamoBlock(Block.blockLapis, 0);
		addCamoBlock(Block.sandStone, 0);
		addCamoBlock(Block.sandStone, 1);
		addCamoBlock(Block.sandStone, 2);
		addCamoBlock(Block.music, 0);
		for(int k = 0; k < 16; k++)
			addCamoBlock(Block.cloth, k);
		addCamoBlock(Block.blockGold, 0);
		addCamoBlock(Block.blockSteel, 0);
		addCamoBlock(Block.brick, 0);
		addCamoBlock(Block.tnt, 0);
		addCamoBlock(Block.bookShelf, 0);
		addCamoBlock(Block.cobblestoneMossy, 0);
		addCamoBlock(Block.obsidian, 0);
		addCamoBlock(Block.oreDiamond, 0);
		addCamoBlock(Block.blockDiamond, 0);
		addCamoBlock(Block.workbench, 0);
		addCamoBlock(Block.oreRedstone, 0);
		addCamoBlock(Block.ice, 0);
		addCamoBlock(Block.blockSnow, 0);
		addCamoBlock(Block.blockClay, 0);
		addCamoBlock(Block.jukebox, 0);
		addCamoBlock(Block.netherrack, 0);
		addCamoBlock(Block.slowSand, 0);
		addCamoBlock(Block.glowStone, 0);
		addCamoBlock(Block.stoneBrick, 0);
		addCamoBlock(Block.stoneBrick, 1);
		addCamoBlock(Block.stoneBrick, 2);
		for(int k = 0; k < 11; k++) {
			addCamoBlock(Block.mushroomCapBrown, k);
			addCamoBlock(Block.mushroomCapRed, k);
		}
		addCamoBlock(Block.melon, 0);
		addCamoBlock(Block.mycelium, 0);
		addCamoBlock(Block.netherBrick, 0);
		addCamoBlock(Block.whiteStone, 0);
		addCamoBlock(Block.whiteStone, 1);
		addCamoBlock(Block.redstoneLampIdle, 0);
		addCamoBlock(Block.oreEmerald, 0);
		addCamoBlock(Block.blockEmerald, 0);
		addCamoBlock(Block.commandBlock, 0);

		maxCamoBlockId = Block.commandBlock.blockID;

		enableClockTicks(true);
		NetworkRegistry.instance().registerGuiHandler(this, new IGuiHandler() {

			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity te = world.getBlockTileEntity(x, y, z);
				if(te == null)
					return null;
				int meta = te.worldObj.getBlockMetadata(te.xCoord, te.yCoord, te.zCoord);
				int blockid = te.worldObj.getBlockId(te.xCoord, te.yCoord, te.zCoord);
				if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.blockID) {
					// TODO WTF?
					ID = GUI_ID_GENERATOR;
				}

				switch(ID) {
				case GUI_ID_GENERATOR:
					return new ContainerGenerator(player, ((TileEntityGeneratorCore) te));
				case GUI_AREA_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorArea) te));
				case GUI_DIRECTIONAL_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorDirectional) te));
				case GUI_DEFLECTOR_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorDeflector) te));
				case GUI_DIRECTIONAL_UPGRADE:
					return new Containerdummy(player, ((TileProjectorExtender) te));
				case GUI_TUBE_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorTube) te));
				case GUI_CAMOFLAGE_UPGRADE:
					return new ContainerCamoflage(player, ((TileUpgradeCamouflage) te));
				case GUI_REACTOR_FIELD:
					return new ContainerProjektor(player, ((TileProjectorReactor) te));
				case GUI_REACTOR_COOLER:
					return new ContainerReactorCooler(player, ((TileEntityReaktorCooler) te));
				case GUI_REACTOR_MONITOR:
					return new ContainerReaktorMonitor(player, ((TileEntityReaktorMonitor) te));
				case GUI_REACTOR_MONITOR_CLIENT:
					return new ContainerReaktorMonitorClient(player, ((TileEntityReaktorMonitorClient) te));
				case GUI_UPGRADE_UNIT:
					return new ContainerUpgradeUnit(player, (TileUpgradeUnit)te);
				case GUI_LOOT_COLLECTOR:
					return new ContainerLootCollector(player, (TileLootCollector)te);
				case GUI_INVENTORY_CONTENTS_FILTER:
					return new ContainerInventoryContentsFilter(player, (TileInventoryContentsFilter)te);
				case GUI_POTION_UPGRADE:
					return new ContainerPotionUpgrade(player, (TilePotionUpgrade)te);
				}
				return null;
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity te = world.getBlockTileEntity(x, y, z);
				if(te == null)
					return null;
				int meta = te.worldObj.getBlockMetadata(te.xCoord, te.yCoord, te.zCoord);
				int blockid = te.worldObj.getBlockId(te.xCoord, te.yCoord, te.zCoord);
				if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.blockID) {
					// TODO WTF?
					ID = GUI_ID_GENERATOR;
				}

				switch(ID) {
				case GUI_ID_GENERATOR:
					return new GuiGenerator(player, ((TileEntityGeneratorCore) te));
				case GUI_AREA_PROJECTOR:
					return new GuiProjektorArea(player, ((TileProjectorArea) te));
				case GUI_DIRECTIONAL_PROJECTOR:
					return new GuiProjektorDirectional(player, ((TileProjectorDirectional) te));
				case GUI_DEFLECTOR_PROJECTOR:
					return new GuiDeflectorDirectional(player, ((TileProjectorDeflector) te));
				case GUI_DIRECTIONAL_UPGRADE:
					return new GuiDirectionalUpgrade(player, ((TileProjectorExtender) te));
				case GUI_TUBE_PROJECTOR:
					return new GuiProjTube(player, ((TileProjectorTube) te));
				case GUI_CAMOFLAGE_UPGRADE:
					return new GuiCamouflageUpgrade(player, ((TileUpgradeCamouflage) te));
				case GUI_REACTOR_FIELD:
					return new GuiReaktorField(player, ((TileProjectorReactor) te));
				case GUI_REACTOR_COOLER:
					return new GuiReaktorCooler(player, ((TileEntityReaktorCooler) te));
				case GUI_REACTOR_MONITOR:
					return new GuiReaktorMonitor(player, ((TileEntityReaktorMonitor) te));
				case GUI_REACTOR_MONITOR_CLIENT:
					return new GuiReaktorMonitorClient(player, ((TileEntityReaktorMonitorClient) te));
				case GUI_UPGRADE_UNIT:
					return new GuiUpgradeUnit(new ContainerUpgradeUnit(player, (TileUpgradeUnit)te));
				case GUI_LOOT_COLLECTOR:
					return new GuiLootCollector(new ContainerLootCollector(player, (TileLootCollector)te));
				case GUI_INVENTORY_CONTENTS_FILTER:
					return new GuiInventoryContentsFilter(new ContainerInventoryContentsFilter(player, (TileInventoryContentsFilter)te));
				case GUI_POTION_UPGRADE:
					return new GuiPotionUpgrade(new ContainerPotionUpgrade(player, (TilePotionUpgrade)te));
				}
				return null;
			}
		});

		APILocator.getNetManager().listen(this);
	}

	@Override
	public boolean onTickInGame() {
		FFWorld.tickAll();
		return true;
	}

	private void addCamoBlock(Block block, int meta)
	{
		int[] t = new int[6];
		for(int k = 0; k < 6; k++)
			t[k] = block.getBlockTextureFromSideAndMetadata(k, meta);
		idtotextur.put(block.blockID + meta*1000, t);
	}

	@PostInit
	public void modsLoaded(FMLPostInitializationEvent evt)
	{
		ExplosionWhitelist.addWhitelistedBlock(MFFSFieldblock);
		ExplosionWhitelist.addWhitelistedBlock(MFFSUpgrades);
		ExplosionWhitelist.addWhitelistedBlock(MFFSMaschines);

		if(Items.getItem("advancedAlloy") != null) {
			// No recipes if IC2 isn't loaded but some other mod has the IC2 API
			// TODO: why bother? 100% of this mod is useless without IC2

			if(enableReactorBlocks) {
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_REACTOR),
						"ADA",
						"BCB",
						"ABA",
						'A', Items.getItem("carbonPlate"),
						'B', Items.getItem("advancedAlloy"),
						'C', new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA),
						'D', Items.getItem("advancedCircuit")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_REACTOR_COOLER),
						"DCD",
						"CAC",
						"DBD",
						'A', Items.getItem("advancedMachine"),
						'B', Block.chest,
						'C', Items.getItem("reactorCondensatorLap"),
						'D', Items.getItem("advancedAlloy")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_REACTOR_MONITOR),
						"ECE",
						"DBD",
						"EAE",
						'A', Items.getItem("advancedMachine"),
						'B', Items.getItem("frequencyTransmitter"),
						'C', Items.getItem("detectorCableItem"),
						'D', Items.getItem("electronicCircuit"),
						'E', Items.getItem("refinedIronIngot")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_REACTOR_MONITOR_CLIENT),
						"ECE",
						"DBD",
						"EAE",
						'A', Items.getItem("machine"),
						'B', Items.getItem("frequencyTransmitter"),
						'C', Item.redstone,
						'D', Items.getItem("electronicCircuit"),
						'E', Items.getItem("refinedIronIngot")
						);
			}

			ModLoader.addRecipe(new ItemStack(MFFSitemMFDwrench),
					"BCB",
					"DAD",
					"DDD",
					'A', Item.diamond,
					'B', Items.getItem("insulatedCopperCableItem"),
					'C', Item.redstone,
					'D', Items.getItem("refinedIronIngot")
					);

			if(!useOldRecipes) {

				ModLoader.addRecipe(new ItemStack(MFFSitemcardempty, 8),
						"AAA",
						"ABA",
						"AAA",
						Character.valueOf('A'), Item.paper,
						Character.valueOf('B'), Items.getItem("electronicCircuit")
						);

				ModLoader.addRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_ENERGY_MODULATOR),
						" ^ ",
						" | ",
						"-M-",

						'^', Items.getItem("frequencyTransmitter"),
						'M', Items.getItem("electronicCircuit"),
						'-', Items.getItem("glassFiberCableItem"),
						'|', Items.getItem("glassFiberCableItem"), // was goldCable
						'O', Items.getItem("electrolyzedWaterCell"),
						'#', Items.getItem("advancedAlloy")
						);

				/*ModLoader.addRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_CONTROL_PANEL),
					"...",
					"...",
					"#C#",
					'.', Block.button,
					'#', Items.getItem("reinforcedStone"),
					'C', Items.getItem("electronicCircuit")
				);*/

				ModLoader.addRecipe(new ItemStack(itemComponent, 4, ItemComponent.META_DIAMOND_LENS),
						"X-X",
						"|*|",
						"X-X",
						'-', Block.glass,
						'|', Block.glass,
						'*', Item.diamond,
						'X', Items.getItem("advancedAlloy")
						);

				ModLoader.addRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE),
						"#^#",
						"$O$",
						"/E/",
						'#', Items.getItem("reinforcedStone"),
						'$', Items.getItem("carbonPlate"),
						'O', new ItemStack(itemComponent, 1, ItemComponent.META_DIAMOND_LENS),
						'/', Item.redstoneRepeater,
						'E', Items.getItem("electrolyzer"),
						'^', new ItemStack(itemComponent, 1, ItemComponent.META_ENERGY_MODULATOR)
						);

				// core
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_CORE),
						"#^#",
						"OMO",
						"CEC",

						'M', Items.getItem("mfeUnit"),
						'^', new ItemStack(itemComponent, 1, ItemComponent.META_ENERGY_MODULATOR),
						'E', Items.getItem("electrolyzer"),
						'#', Items.getItem("advancedAlloy"),
						'O', Items.getItem("electrolyzedWaterCell"),
						'C', Items.getItem("advancedCircuit")
						);

				// area
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA),
						"###",
						"#P#",
						"###",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// dir
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DIR),
						"#",
						"#",
						"P",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// defl
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DEFLECTOR),
						"###",
						" P ",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// tube
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_TUBE),
						"###",
						" P ",
						"###",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_TUBE),
						"# #",
						"#P#",
						"# #",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// extender
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_EXTENDER),
						" O ",
						"# #",
						" # ",
						'#', Items.getItem("reinforcedStone"),
						'O', new ItemStack(itemComponent, 1, ItemComponent.META_DIAMOND_LENS)
						);

				// subwater
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_SUBWATER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.bucketEmpty
						);

				// dome
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_DOME),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electronicCircuit")
						);

				// hardner
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_HARDNER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("carbonPlate")
						);

				// core storage
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_STORAGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electrolyzedWaterCell")
						);

				// core range
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_RANGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("frequencyTransmitter")
						);

				// zapper
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_ZAPPER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("teslaCoil")
						);

				// camo
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CAMO),
						"BAB",
						"ACA",
						"BAB",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.diamond,
						Character.valueOf('C'), Items.getItem("frequencyTransmitter")
						);

				// reactor connector
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_REACTOR_CONNECTOR),
						"ACA",
						"BDB",
						"ACA",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.redstone,
						Character.valueOf('C'), Items.getItem("trippleInsulatedIronCableItem"),
						Character.valueOf('D'), Items.getItem("frequencyTransmitter")
						);

				// inhibitor
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_INHIBITOR),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("machine")
						);
			}
			else
			{

				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_EXTENDER),
						" * ",
						"#C#",
						" # ",
						'#', Items.getItem("advancedAlloy"),
						'*', Item.diamond,
						'D', Items.getItem("frequencyTransmitter")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_TUBE),
						"#*#",
						"*C*",
						"DED",
						'#', Items.getItem("advancedAlloy"),
						'*', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA),
						"BBB",
						"BCB",
						"DED",
						'A', Items.getItem("advancedAlloy"),
						'B', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DEFLECTOR),
						"BAB",
						"ACA",
						"DED",
						'A', Items.getItem("advancedAlloy"),
						'B', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DIR),
						"ABA",
						"ACA",
						"DED",
						'A', Items.getItem("advancedAlloy"),
						'B', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				/*ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_EU_INJECTOR),
					"ABA",
					"CDC",
					"ABA",
					'A', Items.getItem("refinedIronIngot"),
					'B', Items.getItem("insulatedCopperCableItem"),
					'C', Items.getItem("electrolyzedWaterCell"),
					'D', Items.getItem("batBox")
				);*/ // EU injector recipe disabled
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_CORE),
						"ABA",
						"CDC",
						"AEA",
						Character.valueOf('A'), Items.getItem("electrolyzedWaterCell"),
						Character.valueOf('B'), Items.getItem("advancedAlloy"),
						Character.valueOf('C'), Items.getItem("electronicCircuit"),
						Character.valueOf('D'), Items.getItem("frequencyTransmitter"),
						Character.valueOf('E'), Items.getItem("electrolyzer")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_STORAGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_DOME),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electronicCircuit")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_HARDNER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("carbonPlate")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_RANGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("frequencyTransmitter")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_INHIBITOR),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("machine")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_SUBWATER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.bucketEmpty
						);
				ModLoader.addRecipe(new ItemStack(MFFSitemcardempty),
						"AAA",
						"ABA",
						"AAA",
						Character.valueOf('A'), Item.paper,
						Character.valueOf('B'), Items.getItem("electronicCircuit")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_ZAPPER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("teslaCoil")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CAMO),
						"BAB",
						"ACA",
						"BAB",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.diamond,
						Character.valueOf('C'), Items.getItem("frequencyTransmitter")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_REACTOR_CONNECTOR),
						"ACA",
						"BDB",
						"ACA",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.redstone,
						Character.valueOf('C'), Items.getItem("trippleInsulatedIronCableItem"),
						Character.valueOf('D'), Items.getItem("frequencyTransmitter")
						);
			}

			//ModLoader.addRecipe(new ItemStack(MFFSitemMFDReaktorlink), new Object[] { "DCD", "BAB", "CBC", Character.valueOf('A'), Items.getItem("frequencyTransmitter"), Character.valueOf('B'), Items.getItem("electronicCircuit") , Character.valueOf('C'), Items.getItem("carbonPlate"), Character.valueOf('D'), Item.redstone});

			ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDwrench), new Object[]{new ItemStack(MFFSitemMFDoffset)});
			ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDoffset), new Object[]{new ItemStack(MFFSitemMFDwrench)});

			ModLoader.addShapelessRecipe(new ItemStack(MFFSitemcardempty), new Object[] {MFFSitemfc});
			ModLoader.addShapelessRecipe(new ItemStack(MFFSitemcardempty), new Object[] {MFFSitemsclc});
		}

	}

	public static boolean areItemsEqual(ItemStack a, ItemStack b) {
		if(a == null && b == null)
			return true;
		if(a == null || b == null)
			return false;
		if(a.itemID != b.itemID)
			return false;
		if(a.getHasSubtypes() && a.getItemDamage() != b.getItemDamage())
			return false;
		if(a.stackTagCompound == null && b.stackTagCompound == null)
			return true;
		if(a.stackTagCompound != null || b.stackTagCompound != null)
			return false;
		return a.stackTagCompound.equals(b.stackTagCompound);
	}

	@Override
	public String getChannel() {
		return CHANNEL;
	}

	@Override
	public IPacket createS2CPacket(byte id) {
		if(id == PKT_GENERIC_UPDATE)
			return new PacketGenericUpdate();
		if(id == PKT_BOLT_FX)
			return new PacketBoltFX();
		return null;
	}

	@Override
	public IPacket createC2SPacket(byte id) {
		return null;
	}
}