package immibis.ars;

import immibis.core.api.porting.PortableBlockRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class BlockRendererField implements PortableBlockRenderer {
	@Override
	public boolean renderWorldBlock(RenderBlocks rb, IBlockAccess w, int x, int y, int z, Block b, int model) {
		if(b == ARSMod.MFFSFieldblock) {
			int meta = w.getBlockMetadata(x, y, z);
			
			boolean usingCamo = false;
			
			if(BlockForceField.isCamo(meta))
			{
				TileEntity te = w.getBlockTileEntity(x, y, z);
				if(te != null)
				{
					int camoBlock = ((TileCamouflagedField)te).camoBlockId;
					BlockForceField.useTextures = ARSMod.idtotextur.get(camoBlock);
					usingCamo = (BlockForceField.useTextures != null);
					//System.out.println("camoblock "+camoBlock+", textures "+BlockForceField.useTextures);
				}
			}
			
			if(!usingCamo)
			{
				ForgeHooksClient.bindTexture("/immibis/ars/textures/blocks.png", 0);
				rb.renderStandardBlock(b, x, y, z);
				ForgeHooksClient.unbindTexture();
			}
			else
			{
				rb.renderStandardBlock(b, x, y, z);
				BlockForceField.useTextures = null;
			}
			
			return true;
		}
		return false;
	}
	
	@Override
	public void renderInvBlock(RenderBlocks rb, Block b, int meta, int model) {
		// field blocks shouldn't be in inventories - let them be invisible
	}
}

/* $endif$ */