package immibis.ars;

import immibis.core.api.porting.SidedProxy;

import java.io.File;
import java.util.logging.Logger;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class Functions {

	private final static Logger log = Logger.getLogger("Client");

	public static void DisplayInfo(String s) {
		log.info(s);
	}

	public static File getMinecraftDir() {
		return SidedProxy.instance.getMinecraftDir();
	}
	
	private static Property getLegacyOption(String category, String name) {
		ConfigCategory c = ARSMod.config.categories.get(category);
		if(c == null)
			return null;
		Property p = c.get(name);
		if(p == null)
			return null;
		
		c.remove(name);
		if(c.isEmpty())
			ARSMod.config.categories.remove(category);
		return p;
	}

	public static int getIntFromBlockSection(String oldName, String newName, int def) {
		Property old = getLegacyOption("1", oldName);
		if(old != null)
			ARSMod.config.get(Configuration.CATEGORY_GENERAL, newName, def).value = old.value;
		
		return ARSMod.config.get(Configuration.CATEGORY_GENERAL, newName, def).getInt(def);
	}
	
	public static int getActualBlockIdFor(String oldName, String newName, int def) {
		Property old = getLegacyOption("1", oldName);
		if(old != null)
			ARSMod.config.getBlock(newName, def).value = old.value;
		
		return ARSMod.config.getBlock(newName, def).getInt(def);
	}

	public static int getItemIdFor(String oldName, String newName, int def_minus_256) {
		Property old = getLegacyOption("2", oldName);
		if(old != null)
			ARSMod.config.get(Configuration.CATEGORY_ITEM, newName, def_minus_256 + 256).value = String.valueOf(old.getInt(def_minus_256) + 256);
		return ARSMod.config.get(Configuration.CATEGORY_ITEM, newName, def_minus_256 + 256).getInt(def_minus_256 + 256);
	}

	public static void ChattoPlayer(EntityPlayer player, String Message) {
		SidedProxy.instance.sendChat(Message, player);
	}

	public static NBTTagCompound getTAGfromItemstack(ItemStack itemStack) {
		NBTTagCompound tag = itemStack.getTagCompound();
		if (tag == null) {
			tag = new NBTTagCompound();
			itemStack.setTagCompound(tag);
		}
		return tag;
	}

	public static boolean getConfigBoolean(String key, boolean def) {
		return ARSMod.config.get(Configuration.CATEGORY_GENERAL, key, def).getBoolean(def);
	}

	public static int getBalanceOption(String key, int def) {
		return ARSMod.config.get(Configuration.CATEGORY_GENERAL, key, def).getInt(def);
	}

	public static void removeIntFromBlockSection(String key) {
		getLegacyOption("1", key);
	}

}
