package immibis.ars;

import immibis.ars.projectors.TileProjector;
import immibis.ars.projectors.TileProjectorExtender;
import immibis.core.api.porting.SidedProxy;
import immibis.core.api.util.Dir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemMFD_offset extends ItemMFD {

	public ItemMFD_offset(int i) {
		super(i, 2);
		setIconIndex(5);
	}
	
	private int clamp(int i) {
		if(i < -TileProjector.maxOffset)
			return -TileProjector.maxOffset;
		if(i > TileProjector.maxOffset)
			return TileProjector.maxOffset;
		return i;
	}

	@Override
	public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float x1, float x2, float x3) {
		
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te instanceof TileProjector && !(te instanceof TileProjectorExtender)) {
			if(world.isRemote)
				return true;
			
			TileProjector p = (TileProjector)te;
			if(p.getActive()) {
				SidedProxy.instance.sendChat("Cannot move an active forcefield.", entityplayer);
				return true;
			}
			int step = entityplayer.isSneaking() ? -1 : 1;
			switch(side) {
			case Dir.NX: p.offsetX = clamp(p.offsetX + step); break;
			case Dir.NY: p.offsetY = clamp(p.offsetY + step); break;
			case Dir.NZ: p.offsetZ = clamp(p.offsetZ + step); break;
			case Dir.PX: p.offsetX = clamp(p.offsetX - step); break;
			case Dir.PY: p.offsetY = clamp(p.offsetY - step); break;
			case Dir.PZ: p.offsetZ = clamp(p.offsetZ - step); break;
			}
			SidedProxy.instance.sendChat("New field offset: "+p.offsetX+","+p.offsetY+","+p.offsetZ, entityplayer);
			return true;
		}
		return false;
	}
}
