package immibis.ars;

import immibis.core.BasicInventory;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;

public class ContainerReactorCooler extends ContainerMFFS {

	private TileEntityReaktorCooler colerentity;

	public ContainerReactorCooler(EntityPlayer player, TileEntityReaktorCooler tileentity) {
		
		super(player, tileentity);

		colerentity = tileentity;

		addSlot(new Slot(colerentity, 0, 8, 113));
		addSlot(new Slot(colerentity, 1, 26, 113));
		addSlot(new Slot(colerentity, 2, 44, 113));
		addSlot(new Slot(colerentity, 3, 62, 113));
		addSlot(new Slot(colerentity, 4, 80, 113));
		addSlot(new Slot(colerentity, 5, 98, 113));
		addSlot(new Slot(colerentity, 6, 116, 113));
		addSlot(new Slot(colerentity, 7, 134, 113));
		addSlot(new Slot(colerentity, 8, 152, 113));

		for (int k = 0; k < 9; k++) {
			addSlot(new Slot(player.inventory, k, 8 + k * 18, 143));
		}

	}

	@Override
	public void onCraftGuiClosed(EntityPlayer entityplayer) {
		super.onCraftGuiClosed(entityplayer);
		entityplayer.inventorySlots.updateCraftingResults();

	}

	@Override
	public ItemStack transferStackInSlot(int i) {
		if(i < 9)
			BasicInventory.mergeStackIntoRange(inv, player.inventory, i, 0, 9);
		else
			BasicInventory.mergeStackIntoRange(player.inventory, inv, i - 9, 0, 9);
		return null;
	}

}