package immibis.ars;

/* $if jclient$ */

import immibis.core.aspects.ClientOnly;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiContainer;

import org.lwjgl.opengl.GL11;

@ClientOnly
public class GuiCamouflageUpgrade extends GuiContainer {

	private TileUpgradeCamouflage inventory;

	public GuiCamouflageUpgrade(EntityPlayer inventoryplayer, TileUpgradeCamouflage tileEntity_Camoflage_Upgrade) {

		super(new ContainerCamoflage(inventoryplayer, tileEntity_Camoflage_Upgrade));
		inventory = tileEntity_Camoflage_Upgrade;

	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {

		int textur = mc.renderEngine.getTexture("/immibis/ars/textures/camo.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.renderEngine.bindTexture(textur);
		int w = (width - xSize) / 2;
		int k = (height - ySize) / 2;
		drawTexturedModalRect(w, k, 0, 0, xSize, ySize);
	}

	@Override
	/* $if mc < 1.4$
	protected void drawGuiContainerForegroundLayer() {
	$else$ */
	protected void drawGuiContainerForegroundLayer(int par1, int par2) { 
	/* $endif$ */

		fontRenderer.drawString("Camouflage upgrade", 5, 5, 0x404040);

		fontRenderer.drawString("Block pattern:", 20, 35, 0x404040);

		if (mod_AdvancedRepulsionSystems.idtotextur.containsKey(inventory.getItem_ID())) {
			fontRenderer.drawString("OK", 140, 35, 0x404040);
		}

	}

}

/* $endif$ */
