package immibis.ars;


import ic2.api.Items;
import ic2.common.TileEntityNuclearReactor;
import net.minecraft.src.*;

public class TileEntityReaktorCooler extends TileUpgradePassive implements IInventory {

	private boolean isreaktor;
	private ItemStack inventory[];
	private int reaktorx;
	private int reaktory;
	private int reaktorz;
	private int maxheat;
	private int heat;
	private int mode;
	private int targetheat;

	public TileEntityReaktorCooler() {

		inventory = new ItemStack[9];
		mode = 0;
		targetheat = 0;

	}
	
	@Override
	public int[] getUpdate() {
		return new int[] {maxheat, heat, mode, targetheat};
	}
	
	@Override
	public void handleUpdate(int[] p) {
		maxheat = p[0];
		heat = p[1];
		mode = p[2];
		targetheat = p[3];
	}
	
	@Override
	public void handleButton(int id) {
		/* $if mc < 1.3$
		switch (id) {

		case 1:
			if (getTargetheat() <= getMaxheat()) {
				setTargetheat(getTargetheat() + 100);
				if (getTargetheat() > getMaxheat()) {
					setTargetheat(getMaxheat());
				}
			}
			break;
		case 2:
			if (getTargetheat() >= 0) {
				setTargetheat(getTargetheat() - 100);
				if (getTargetheat() < 0) {
					setTargetheat(0);
				}
			}

			break;

		case 3:
			setMode(0);
			break;

		case 4:
			setMode(1);
			break;
		case 5:
			setMode(2);
			break;
		case 6:
			setMode(3);
			break;

		}
		$endif$ */
	}

	public int getMode() {
		return mode;
	}

	public void setMode(int mode) {
		this.mode = mode;
		updateCount++;
	}

	@Override
	public void updateEntity() {

		super.updateEntity();

		if(!worldObj.isRemote) {

			updatecheck();

			if (isIsreaktor()) {

				TileEntity tileEntity = worldObj.getBlockTileEntity(reaktorx, reaktory, reaktorz);

				if (tileEntity == null) {
					setIsreaktor(false);
				}

				if (tileEntity instanceof TileEntityNuclearReactor) {

					heat = ((TileEntityNuclearReactor) tileEntity).heat;
					updateCount++;

					/* $if mc < 1.3$
					if (this.getMode() != 0 && getActive()) {

						switch (getMode()) {
						case 1: // cooler
							if ((getTargetheat() + 50) < heat) {
								reactorcooler((TileEntityNuclearReactor) tileEntity);
							}
							break;
						case 2: // heater
							if ((getTargetheat() - 50) > heat) {
								reactorheater((TileEntityNuclearReactor) tileEntity);
							}
							break;

						case 3: // balance
							if ((getTargetheat() + 100) < heat) {
								reactorcooler((TileEntityNuclearReactor) tileEntity);
								break;
							}

							if ((getTargetheat() - 100) > heat) {
								reactorheater((TileEntityNuclearReactor) tileEntity);
								break;
							}

						}

					}
					$else$ */
					if(getActive())
						doCondensatorRecharging((TileEntityNuclearReactor)tileEntity);
					/* $endif$ */
				}
			}
		}
	}

	/* $if mc < 1.3$
	private void reactorheater(TileEntityNuclearReactor tileEntity) {
		for (int i = 0; i < inventory.length; i++) {
			if (getStackInSlot(i) != null) {
				if ((getStackInSlot(i).getItem() == Items.getItem("lavaCell").getItem())) {

					if (getStackInSlot(i).stackSize == 1) {
						inventory[i] = null;
					} else {
						this.getStackInSlot(i).stackSize--;
					}

					((TileEntityNuclearReactor) tileEntity).heat = ((TileEntityNuclearReactor) tileEntity).heat + 100;
					break;
				}
			}
		}
	}

	private void reactorcooler(TileEntityNuclearReactor tileEntity) {
		for (int i = 0; i < inventory.length; i++) {
			if (getStackInSlot(i) != null) {

				if ((getStackInSlot(i).getItem() == Items.getItem("waterCell").getItem())) {
					if (getStackInSlot(i).stackSize == 1) {
						inventory[i] = null;
					} else {
						this.getStackInSlot(i).stackSize--;
					}
					((TileEntityNuclearReactor) tileEntity).heat = ((TileEntityNuclearReactor) tileEntity).heat - 50;
					if (((TileEntityNuclearReactor) tileEntity).heat < 0) {
						((TileEntityNuclearReactor) tileEntity).heat = 0;
					}
					break;
				}

				if (getStackInSlot(i).itemID == Block.ice.blockID) {
					if (getStackInSlot(i).stackSize == 1) {
						inventory[i] = null;
					} else {
						this.getStackInSlot(i).stackSize--;
					}
					((TileEntityNuclearReactor) tileEntity).heat = ((TileEntityNuclearReactor) tileEntity).heat - 100;
					if (((TileEntityNuclearReactor) tileEntity).heat < 0) {
						((TileEntityNuclearReactor) tileEntity).heat = 0;
					}
					break;
				}

			}
		}

	}
	$else$ */
	
	private static ItemStack rsh = Items.getItem("reactorCondensator");
	private static ItemStack lzh = Items.getItem("reactorCondensatorLap");
	private void doCondensatorRecharging(IInventory nr) {
		
		// count lapis and redstone in inventory
		int availRedstone = 0, availLapis = 0;
		int n = getSizeInventory();
		for(int k = 0; k < n; k++) {
			ItemStack is = getStackInSlot(k);
			if(is != null) {
				if(is.itemID == Item.dyePowder.shiftedIndex && is.getItemDamage() == 4)
					availLapis += is.stackSize;
				else if(is.itemID == Item.redstone.shiftedIndex)
					availRedstone += is.stackSize;
			}
		}
		
		int usedRedstone = 0, usedLapis = 0;
		n = nr.getSizeInventory();
		for(int k = 0; k < n; k++) {
			ItemStack is = nr.getStackInSlot(k);
			if(is == null || is.getItemDamage() < 7000)
				continue;
			if(is.itemID == rsh.itemID && usedRedstone < availRedstone) {
				nr.setInventorySlotContents(k, rechargeCondensator(is, Item.redstone, 0));
				usedRedstone++;
			} else if(is.itemID == lzh.itemID) {
				if(usedLapis < availLapis) {
					nr.setInventorySlotContents(k, rechargeCondensator(is, Item.dyePowder, 4));
					usedLapis++;
				} else if(usedRedstone < availRedstone) {
					nr.setInventorySlotContents(k, rechargeCondensator(is, Item.redstone, 0));
					usedRedstone++;
				}
			}
		}
		
		if(usedRedstone > 0 || usedLapis > 0) {
			n = getSizeInventory();
			for(int k = 0; k < n; k++) {
				ItemStack is = getStackInSlot(k);
				if(is != null) {
					if(is.itemID == Item.dyePowder.shiftedIndex && is.getItemDamage() == 4) {
						int subtract = Math.min(usedLapis, is.stackSize);
						is.stackSize -= subtract;
						usedLapis -= subtract;
						
					} else if(is.itemID == Item.redstone.shiftedIndex) {
						int subtract = Math.min(usedRedstone, is.stackSize);
						is.stackSize -= subtract;
						usedRedstone -= subtract;
					}
					if(is.stackSize == 0)
						setInventorySlotContents(k, null);
				}
			}
		}
	}
	
	private InventoryCrafting rechargeInv = new InventoryCrafting(new Container() {
		@Override public boolean canInteractWith(EntityPlayer entityplayer) {return false;}
		@Override public void onCraftMatrixChanged(IInventory iinventory) {}
	}, 3, 3);
	
	private ItemStack rechargeCondensator(ItemStack cond, Item item, int meta) {
		rechargeInv.setInventorySlotContents(0, cond);
		rechargeInv.setInventorySlotContents(1, new ItemStack(item, 1, meta));
		/* $if mc > 1.4$ */
		return CraftingManager.getInstance().findMatchingRecipe(rechargeInv, worldObj);
		/* $else$
		return CraftingManager.getInstance().findMatchingRecipe(rechargeInv);
		$endif$ */
	}
	
	/* $endif$ */

	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);
		targetheat = nbttagcompound.getInteger("targetheat");
		mode = nbttagcompound.getInteger("mode");

		NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
		inventory = new ItemStack[getSizeInventory()];
		for (int i = 0; i < nbttaglist.tagCount(); i++) {
			NBTTagCompound nbttagcompound1 = (NBTTagCompound) nbttaglist.tagAt(i);
			byte byte0 = nbttagcompound1.getByte("Slot");
			if (byte0 >= 0 && byte0 < inventory.length) {
				inventory[byte0] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
			}
		}

	}

	@Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);

		nbttagcompound.setInteger("targetheat", targetheat);
		nbttagcompound.setInteger("mode", mode);

		NBTTagList nbttaglist = new NBTTagList();
		for (int i = 0; i < inventory.length; i++) {
			if (inventory[i] != null) {
				NBTTagCompound nbttagcompound1 = new NBTTagCompound();
				nbttagcompound1.setByte("Slot", (byte) i);
				inventory[i].writeToNBT(nbttagcompound1);
				nbttaglist.appendTag(nbttagcompound1);
			}
		}

		nbttagcompound.setTag("Items", nbttaglist);
	}

	public int getTargetheat() {
		return targetheat;
	}

	public void setTargetheat(int targetheat) {
		this.targetheat = targetheat;
		updateCount++;
	}

	public void setMaxheat(int maxheat) {
		this.maxheat = maxheat;
		updateCount++;
	}

	public int getHeat() {
		return heat;
	}

	public void setHeat(int heat) {
		this.heat = heat;
		updateCount++;
	}

	public boolean isIsreaktor() {
		return isreaktor;
	}

	public void setIsreaktor(boolean isreaktor) {
		this.isreaktor = isreaktor;
		updateCount++;
	}

	public int getReaktorx() {
		return reaktorx;
	}

	public void setReaktorx(int reaktorx) {
		this.reaktorx = reaktorx;
	}

	public int getReaktory() {
		return reaktory;
	}

	public void setReaktory(int reaktory) {
		this.reaktory = reaktory;
	}

	public int getReaktorz() {
		return reaktorz;
	}

	public void setReaktorz(int reaktorz) {
		this.reaktorz = reaktorz;
	}

	public int getMaxheat() {
		return maxheat;
	}

	@Override
	public int getSizeInventory() {
		return inventory.length;
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		if (inventory[i] != null) {
			if (inventory[i].stackSize <= j) {
				ItemStack itemstack = inventory[i];
				inventory[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = inventory[i].splitStack(j);
			if (inventory[i].stackSize == 0) {
				inventory[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}
	
	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		inventory[i] = itemstack;
		if (itemstack != null && itemstack.stackSize > getInventoryStackLimit()) {
			itemstack.stackSize = getInventoryStackLimit();
		}
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return inventory[i];
	}

	@Override
	public String getInvName() {

		return "Reactor Cooler";
	}

	@Override
	public int getInventoryStackLimit() {
		return 64;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		} else {
			return entityplayer.getDistance((double) xCoord + 0.5D, (double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
		}
	}

	@Override
	public void openChest() {

	}

	@Override
	public void closeChest() {

	}

	@Override
	public ItemStack getStackInSlotOnClosing(int var1) {
		// TODO Auto-generated method stub
		return null;
	}

}
