package mods.immibis.cloudstorage;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.power.PowerHandler.Type;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CloudActionInsertMJ extends CloudAction {

	@Override
	public boolean apply(CloudActionCoords coords, World world, Storage s) {
		TileEntity te = world.getTileEntity(coords.x, coords.y, coords.z);
		if(!(te instanceof IPowerReceptor))
			return false;
		
		if(s.storedMJ < 100) 
		{
			// 100 EU -> 40 MJ
			if(s.storedEU >= 100)
			{
				s.storedMJ += 40;
				s.storedEU -= 100;
			}
			// 100 RF -> 10 MJ
			if(s.storedRF >= 100)
			{
				s.storedMJ += 10;
				s.storedRF -= 100;
			}
		}
		if(s.storedMJ < 1)
			return true;
			
		ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[coords.side];
		PowerHandler.PowerReceiver ph = ((IPowerReceptor)te).getPowerReceiver(dir);
		double used = ph.receiveEnergy(Type.PIPE, Math.min(s.storedMJ, ph.getMaxEnergyReceived()), dir);
		
		if(used == 0)
			return true;
		
		s.storedMJ -= used;
		s.setDirty(true);
		return true;
	}

	@Override
	public CloudActionType getType() {
		return CloudActionType.INSERT_MJ;
	}
	
	@Override
	public String toString() {
		return "insert Minecraft Joules";
	}

}
