package mods.immibis.cloudstorage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import mods.immibis.cobaltite.AssignedItem;
import mods.immibis.cobaltite.CobaltiteMod;
import mods.immibis.cobaltite.ModBase;
import mods.immibis.cobaltite.NonTileGUI;
import mods.immibis.cobaltite.PacketType;
import mods.immibis.core.api.FMLModInfo;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@Mod(modid="Cloud Storage", name="Cloud Storage", version="58.1.1")
@CobaltiteMod(channel=CloudStorage.CHANNEL)
@FMLModInfo(url="", description="Totally not overpowered.", authors="immibis")
public class CloudStorage extends ModBase {
	
	@Instance("Cloud Storage")
	public static CloudStorage INSTANCE;
	
	@NonTileGUI(container=ContainerBrowser.class, gui=GuiBrowser.class)
	public static final int GUI_BROWSE = 1;
	
	@NonTileGUI(container=ContainerFilter.class, gui=GuiFilter.class)
	public static final int GUI_FILTER = 2;
	
	public static final String CHANNEL = "CloudStorage";
	
	@PacketType(direction=PacketType.Direction.S2C, type=PacketStorageInfo.class)
	public static final int S2C_STORAGE_GUI_SYNC = 0;
	
	@PacketType(direction=PacketType.Direction.C2S, type=PacketSetVisibleSlot.class)
	public static final int C2S_SET_VISIBLE_SLOT = 1;
	
	@AssignedItem(id="configurator")
	public static ItemConfigurator itemConfigurator;
	
	@AssignedItem(id="copier")
	public static ItemCopier itemCopier;
	
	private static final String SAVE_DATA_IDENTIFIER = "CloudStorage";
	public static Storage getStorage(String username) {
		assert FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
		
		String name = SAVE_DATA_IDENTIFIER + "-" + username;
		
		MapStorage mapStorage = MinecraftServer.getServer().worldServers[0].mapStorage;
		Storage s = (Storage)mapStorage.loadData(Storage.class, name);
		if(s == null)
		{
			s = new Storage(name);
			mapStorage.setData(name, s);
		}
		return s;
	}
	
	@EventHandler public void base_init(FMLInitializationEvent evt) {super._init(evt);}
	@EventHandler public void base_preinit(FMLPreInitializationEvent evt) {super._preinit(evt);}
	
	@Override
	@SideOnly(Side.CLIENT)
	protected void clientInit() throws Exception {
		
	}
	
	@Override
	protected void addRecipes() throws Exception {
		GameRegistry.addShapelessRecipe(new ItemStack(itemConfigurator), Blocks.dirt, Items.redstone);
		GameRegistry.addShapelessRecipe(new ItemStack(itemCopier), Blocks.dirt, Blocks.dirt, Items.redstone);
	}
	
	@SubscribeEvent
	public void onServerTick(TickEvent.ServerTickEvent evt) {
		if(evt.phase != TickEvent.Phase.START) return;
		
		for(Object player : MinecraftServer.getServer().getConfigurationManager().playerEntityList)
		{
			Storage s = getStorage(((EntityPlayerMP)player).getDisplayName()); // TODO WRONG!
			List<CloudActionCoords> toRemove = null;
			for(Map.Entry<CloudActionCoords, CloudAction> e : s.actions.entrySet())
			{
				CloudActionCoords key = e.getKey();
				World world = DimensionManager.getWorld(key.dimension);
				if(world == null || !world.blockExists(key.x, key.y, key.z))
					continue;
				if(!e.getValue().apply(key, world, s))
				{
					//System.out.println("poofing action at "+key.x+","+key.y+","+key.z);
					ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[key.side];
					
					// was 2000/4 which is a tiny smoke effect
					world.playAuxSFX(2004, key.x+side.offsetX, key.y+side.offsetY, key.z+side.offsetZ, 0);
					
					if(toRemove == null)
						toRemove = new ArrayList<CloudActionCoords>();
					toRemove.add(e.getKey());
				}
			}
			if(toRemove != null)
			{
				for(CloudActionCoords key : toRemove)
				{
					s.actions.remove(key);
				}
				s.setDirty(true);
			}
		}
	}
	
	@Override
	protected void sharedInit() throws Exception {
		MinecraftForge.EVENT_BUS.register(this);
	}
	
	@EventHandler
	public void onServerStart(FMLServerStartingEvent evt) {
		evt.registerServerCommand(new CommandBase() {
			@Override
			public void processCommand(ICommandSender icommandsender, String[] astring) {
				if(icommandsender instanceof EntityPlayerMP)
					((EntityPlayerMP)icommandsender).openGui(INSTANCE, GUI_BROWSE, ((EntityPlayerMP)icommandsender).worldObj, 0, 0, 0);
			}
			
			@Override
			public String getCommandUsage(ICommandSender icommandsender) {
				return "/cloud";
			}
			
			@Override
			public boolean canCommandSenderUseCommand(ICommandSender par1iCommandSender) {
				return par1iCommandSender instanceof EntityPlayer;
			}
			
			@Override
			public String getCommandName() {
				return "cloud";
			}
		});
	}
	
	/*@ForgeSubscribe
	public void onPlayerConstruct(EntityConstructing evt) {
		if(evt.entity instanceof EntityPlayerMP)
			evt.entity.registerExtendedProperties(PlayerExtData.IDENTIFIER, new PlayerExtData());
	}*/
}
