package mods.immibis.chunkloader;


import java.util.ArrayList;

import mods.immibis.core.BlockCombined;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockChunkLoader extends BlockCombined {
	
	protected BlockChunkLoader(int id) {
		super(id, Material.iron, "immibis/chunkloader", new String[] {"chunkloader"});
		setUnlocalizedName("immibis/chunkloader:chunkloader");
	}
	
	@Override
	public boolean removeBlockByPlayer(World w, EntityPlayer player, int x, int y, int z) {
		TileChunkLoader tcl = (TileChunkLoader)w.getBlockTileEntity(x, y, z);
		if(!super.removeBlockByPlayer(w, player, x, y, z))
			return false;
		if(w.isRemote)
			return true;
		Logging.onRemoved(tcl.getLoaderInfo(), player.username);
		return true;
	}
	
	@Override
	public void onBlockPlacedBy(World w, int x, int y, int z, EntityLiving player, ItemStack stack) {
		super.onBlockPlacedBy(w, x, y, z, player, stack);
		if(w.isRemote)
			return;
		TileChunkLoader tile = (TileChunkLoader)w.getBlockTileEntity(x, y, z);
		if(player instanceof EntityPlayer) {
			tile.owner = ((EntityPlayer)player).username;
			tile.radius = 0;
		} else {
			tile.owner = null;
			tile.radius = -1;
		}
		tile.limitRadius();
		tile.loaderChanged((player instanceof EntityPlayer ? ((EntityPlayer)player).username : player.toString()), true);
		tile.loadChunks();
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		if(data == 0)
			return new TileChunkLoader();
		return null;
	}

	@Override
	public void addCreativeItems(ArrayList arraylist) {
		arraylist.add(new ItemStack(this, 1, 0));
	}

	@Override
	public Icon getIcon(int side, int data) {
		return blockIcon;
	}

}
