package mods.immibis.chunkloader.porting;


import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

import mods.immibis.chunkloader.DimensionalAnchors;
import mods.immibis.chunkloader.WorldInfo;
import mods.immibis.core.Config;
import net.minecraft.server.management.PlayerInstance;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeChunkManager.LoadingCallback;
import net.minecraftforge.common.ForgeChunkManager.Ticket;
import net.minecraftforge.common.ForgeChunkManager.Type;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityEvent.CanUpdate;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;

public class ChunkLoadInterface132 extends ChunkLoadInterface implements LoadingCallback {
	
	private static Field getField(Class<?> clazz, String name) throws NoSuchFieldException, SecurityException {
		Field f = clazz.getDeclaredField(name);
		f.setAccessible(true);
		return f;
	}
	
	@SuppressWarnings("unchecked")
	public ChunkLoadInterface132() {
		boolean bypassForgeLimits = Config.getBoolean("chunkloader.bypassForgeChunkLimits", true);
		
		if(bypassForgeLimits) {
			try {
				boolean overridesEnabled = getField(ForgeChunkManager.class, "overridesEnabled").getBoolean(null);
				
				Map<String, Integer> ticketConstraints = (Map<String, Integer>)getField(ForgeChunkManager.class, "ticketConstraints").get(null);
				Map<String, Integer> chunkConstraints = (Map<String, Integer>)getField(ForgeChunkManager.class, "chunkConstraints").get(null);
				
				if(!overridesEnabled) {
					ticketConstraints.clear();
					chunkConstraints.clear();
					getField(ForgeChunkManager.class, "overridesEnabled").set(null, true);
				}
				
				String modid = Loader.instance().getModObjectList().inverse().get(DimensionalAnchors.instance).getModId();
				
				ticketConstraints.put(modid, Integer.MAX_VALUE);
				chunkConstraints.put(modid, Integer.MAX_VALUE);
				
				DimensionalAnchors.logger.info("Bypassed Forge chunk limits");
				
			} catch(Exception e) {
				throw new RuntimeException(e);
			}
		}
		
		ForgeChunkManager.setForcedChunkLoadingCallback(DimensionalAnchors.instance, this);
		
		MinecraftForge.EVENT_BUS.register(this);
	}
	
	@Override
	public void ticketsLoaded(List<Ticket> tickets, World world) {
		for(Ticket t : tickets)
			ForgeChunkManager.releaseTicket(t);
	}
	
	@Override
	public void onLoadWorld(WorldInfo w) {
		DimensionalAnchors.logger.fine("Requesting chunk loading ticket for "+w.getName());
		w.cliData = ForgeChunkManager.requestTicket(DimensionalAnchors.instance, w.getWorld(), Type.NORMAL);
		if(w.cliData == null)
			throw new RuntimeException("Failed to get chunk loading ticket for "+w.getName());
	}
	
	@Override
	public void onUnloadWorld(WorldInfo w) {
		DimensionalAnchors.logger.fine("World unloaded: "+w.getName());
		
		// too late to release the ticket, so we release it next time the world is loaded instead
		//ForgeChunkManager.releaseTicket((Ticket)w.cliData);
	}
	
	@Override
	public void addChunk(WorldInfo w, ChunkCoordIntPair ccip) {
		ForgeChunkManager.forceChunk((Ticket)w.cliData, ccip);
	}
	
	@Override
	public void removeChunk(WorldInfo w, ChunkCoordIntPair ccip) {
		ForgeChunkManager.unforceChunk((Ticket)w.cliData, ccip);
		
		WorldServer ws = w.getWorld();
		
		// bugfix: if no mods are forcing the chunk and no players are watching it, unload it
		if(!ForgeChunkManager.getPersistentChunksFor(ws).containsKey(ccip)
			&& !arePlayersWatchingChunk(ws.getPlayerManager(), ccip.chunkXPos, ccip.chunkZPos)) {
			
			ws.theChunkProviderServer.unloadChunksIfNotNearSpawn(ccip.chunkXPos, ccip.chunkZPos);
		}
	}
	
	@ForgeSubscribe
	public void checkEntityUpdate(CanUpdate evt) {
		if(!evt.canUpdate && !evt.entity.worldObj.isRemote) {
			int x = evt.entity.chunkCoordX;
			int z = evt.entity.chunkCoordZ;
			evt.canUpdate = DimensionalAnchors.getWorld(evt.entity.worldObj).isChunkForceLoaded(new ChunkCoordIntPair(x, z));
		}
	}
	
	public static boolean arePlayersWatchingChunk(PlayerManager pm, int x, int z) {
		PlayerInstance chunk = pm.getOrCreateChunkWatcher(x, z, false);
		if(chunk == null)
			return false;
		
		return !ReflectionHelper.<List<?>, PlayerInstance>getPrivateValue(PlayerInstance.class, chunk, 0).isEmpty();
	}
}
