package immibis.core;

import immibis.core.api.APILocator;
import immibis.core.api.net.IPacket;
import immibis.core.api.net.IPacketMap;
import immibis.core.api.porting.SidedProxy;
import immibis.core.coremod.CoreModOptions;
import immibis.core.impl.IDAllocator;
import immibis.core.impl.IDType;
import immibis.core.impl.IIDSet;
import immibis.core.impl.MultiInterfaceClassTransformer;
import immibis.core.impl.NetworkingManager;
import immibis.core.microblock.MicroblockSystem;
import immibis.core.microblock.PacketMicroblockPlace;
import immibis.core.microblock.PacketUpdateBreakingPart;
import immibis.core.multipart.MultipartSystem;
import immibis.core.multipart.PacketMultipartDigStart;
import immibis.core.net.FragmentSequence;
import immibis.core.net.PacketButtonPress;
import immibis.core.net.PacketFragment;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.RelaunchClassLoader;

public class ImmibisCore implements IPacketMap {
	
	public static final String VERSION = "52.3.0";
	public static final String MODID = "ImmibisCore";
	public static final String NAME = "Immibis Core";

	public static final int PACKET_TYPE_S2C_STRING_GUI = 0; // Unused
	public static final int PACKET_TYPE_S2C_MULTIPART_DESCRIPTION = 1; // Unused (has a separate channel)
	public static final int PACKET_TYPE_C2S_MICROBLOCK_DIG_START = 2;
	public static final int PACKET_TYPE_C2S_MICROBLOCK_PLACE = 3;
	public static final int PACKET_TYPE_S2C_UPDATE_BREAKING_PART = 4;
	public static final int PACKET_TYPE_FRAGMENT = 5;
	public static final int PACKET_TYPE_C2S_BUTTON_PRESS = 6;

	public static final String CHANNEL = "ImmibisCore";
	public static SidedProxy sidedProxy;

	public static IDAllocator idAllocator = new IDAllocator();
	public static NetworkingManager networkingManager = new NetworkingManager();

	public static final java.util.Timer TIMER = new java.util.Timer("Immibis Core background task", false);
	
	public static boolean isCoreModActive;

	public void preInit(FMLPreInitializationEvent evt) {
		
		SidedProxy.instance = sidedProxy;
		
		CoreModOptions.load(false, SidedProxy.instance.getMinecraftDir());

		if(CoreModOptions.microblocksEnabled)
		{
			MicroblockSystem.INSTANCE = new MicroblockSystem();
			MicroblockSystem.INSTANCE.preinit();
		}
		
		BlockMultiTile.model = BlockMultiTile.normalModel = SidedProxy.instance.getUniqueBlockModelID("immibis.core.CoreBlockRenderer", true);

		APILocator.getNetManager().listen(this);

		FragmentSequence.init();
		MainThreadTaskQueue.init();
	}

	public void init(FMLInitializationEvent evt) {
		
		MultipartSystem.init();
		
		if(MicroblockSystem.INSTANCE != null)
			MicroblockSystem.INSTANCE.init();
		
		idAllocator.allocate(new IIDSet() {
			@Override
			public int getIDFor(String name, IDType type, int _default) {
				switch(type) {
				case TerrainBlock:
					return Config.config.getTerrainBlock(Configuration.CATEGORY_BLOCK, name, _default, null).getInt(_default);
				case Block:
					return Config.config.getBlock(name+".id", _default).getInt(_default);
				case Item:
					return Config.config.get(Configuration.CATEGORY_ITEM, name, _default).getInt(_default);
				}
				return 0;
			}
		});
		
		Config.save();
	}

	public void postInit(FMLPostInitializationEvent evt) {
		if(MicroblockSystem.INSTANCE != null)
			MicroblockSystem.INSTANCE.postinit();
	}

	public static ImmibisCore instance;

	public ImmibisCore() {
		instance = this;
	}



	public static boolean areItemsEqual(ItemStack a, ItemStack b) {
		if(a == null && b == null)
			return true;
		if(a == null || b == null)
			return false;
		if(a.itemID != b.itemID)
			return false;
		if(a.getHasSubtypes() && a.getItemDamage() != b.getItemDamage())
			return false;
		if(a.stackTagCompound == null && b.stackTagCompound == null)
			return true;
		if(a.stackTagCompound != null || b.stackTagCompound != null)
			return false;
		return a.stackTagCompound.equals(b.stackTagCompound);
	}

	@Override
	public String getChannel() {
		return CHANNEL;
	}

	@Override
	public IPacket createS2CPacket(byte id) {
		if(id == PACKET_TYPE_FRAGMENT)
			return new PacketFragment();
		if(id == PACKET_TYPE_S2C_UPDATE_BREAKING_PART)
			return new PacketUpdateBreakingPart();
		return null;
	}

	@Override
	public IPacket createC2SPacket(byte id) {
		if(id == PACKET_TYPE_C2S_BUTTON_PRESS)
			return new PacketButtonPress(0);
		if(id == PACKET_TYPE_C2S_MICROBLOCK_DIG_START)
			return new PacketMultipartDigStart();
		if(id == PACKET_TYPE_C2S_MICROBLOCK_PLACE)
			return new PacketMicroblockPlace();
		if(id == PACKET_TYPE_FRAGMENT)
			return new PacketFragment();
		return null;
	}

	static {
		((RelaunchClassLoader)ImmibisCore.class.getClassLoader()).registerTransformer(MultiInterfaceClassTransformer.class.getName());
	}

}
