package immibis.core.coremod;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;

public class CoreModOptions {
	public static boolean microblocksEnabled;
	
	private static Properties props;
	
	private static boolean loaded;
	private static File configFile;
	
	public static void load(boolean fromCoreMod, File minecraftDir) {
		if(loaded)
			return;
		
		loaded = true;
		
		File configDir = new File(minecraftDir, "config");
		if(!configDir.exists() && !configDir.mkdirs())
			throw new RuntimeException("Couldn't create directory: "+configDir);
		
		configFile = new File(configDir, "immibis-coremod.cfg");
		
		props = new Properties();
		if(configFile.exists()) {
			try {
				props.load(new FileReader(configFile));
			} catch(IOException ex) {
				throw new RuntimeException(ex);
			}
		}
		
		microblocksEnabled = getBoolean("enableMicroblocks", true);
		
		if(microblocksEnabled) {
			MicroblockSupporterTransformer.blockClasses.addAll(Arrays.asList(getString("microblockTransformer.blockClasses",
				"buildcraft.transport.BlockGenericPipe;"+
				"thermalexpansion.transport.block.BlockConduit;"+
				"ic2.core.block.wiring.BlockCable"
			).split(";")));
			
			MicroblockSupporterTransformer.tileClasses.addAll(Arrays.asList(getString("microblockTransformer.tileEntityClasses",
				"buildcraft.transport.TileGenericPipe;"+
				"thermalexpansion.transport.tileentity.TileConduitEnergy;"+
				"thermalexpansion.transport.tileentity.TileConduitLiquid;"+
				"ic2.core.block.wiring.TileEntityCable"
			).split(";")));
		}
	}
	
	public static boolean getBoolean(String name, boolean def) {
		if(props.containsKey(name)) {
			String v = props.getProperty(name);
			if(v.equals("true"))
				return true;
			if(v.equals("false"))
				return false;
		}
		props.setProperty(name, def ? "true" : "false");
		save();
		return def;
	}
	
	public static String getString(String name, String def) {
		if(props.containsKey(name))
			return props.getProperty(name);
		props.setProperty(name, def);
		save();
		return def;
	}
	
	public static void save() {
		try {
			props.store(new FileWriter(configFile),
				"See http://www.minecraftforum.net/topic/1001131-x/ for more information on these options."
			);
			
		} catch(IOException ex) {
			throw new RuntimeException(ex);
		}
	}
}
