package immibis.core;

import immibis.core.api.porting.SidedProxy;

import java.util.ArrayList;

import net.minecraft.src.*;

public abstract class ItemBlockMultiTile extends ItemBlock {
	public int max_meta = 0;
	
	public ItemBlockMultiTile(int id, int max_meta) {
		super(id);
		this.max_meta = max_meta;
		
		for(int k = 0; k < max_meta; k++)
			SidedProxy.instance.addLocalization(shiftedIndex+"."+k+".name", getName(k));
	}
	
	/* $if client2$ */
	public abstract void renderItem(RenderBlocks rb, int meta);
	/* $endif$ */
	
	@Override
    public String getItemNameIS(ItemStack stack)
    {
		return shiftedIndex+"."+stack.getItemDamage();
    }
	
	public abstract TileEntity createTileEntity(int meta);
	public abstract String getName(int meta);

	/* $if mc < 1.3$
	@Override
	public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7)
    {
        int var8 = par3World.getBlockId(par4, par5, par6);

        if (var8 == Block.snow.blockID)
        {
            par7 = 1;
        }
        else if (var8 != Block.vine.blockID && var8 != Block.tallGrass.blockID && var8 != Block.deadBush.blockID)
        {
            if (par7 == 0)
            {
                --par5;
            }

            if (par7 == 1)
            {
                ++par5;
            }

            if (par7 == 2)
            {
                --par6;
            }

            if (par7 == 3)
            {
                ++par6;
            }

            if (par7 == 4)
            {
                --par4;
            }

            if (par7 == 5)
            {
                ++par4;
            }
        }
        
        int block = getBlockID();

        if (par1ItemStack.stackSize == 0)
        {
            return false;
        }
        else if (!par2EntityPlayer.canPlayerEdit(par4, par5, par6))
        {
            return false;
        }
        else if (par5 == 255 && Block.blocksList[block].blockMaterial.isSolid())
        {
            return false;
        }
        else if (par3World.canBlockBePlacedAt(block, par4, par5, par6, false, par7))
        {
            Block var9 = Block.blocksList[block];

            if (par3World.setBlockAndMetadataWithNotify(par4, par5, par6, block, 0))
            {
            	par3World.setBlockTileEntity(par4, par5, par6, createTileEntity(par1ItemStack.getItemDamage()));
                if (par3World.getBlockId(par4, par5, par6) == block)
                {
                    Block.blocksList[block].onBlockPlaced(par3World, par4, par5, par6, par7);
                    Block.blocksList[block].onBlockPlacedBy(par3World, par4, par5, par6, par2EntityPlayer);
                }

                par3World.playSoundEffect((double)((float)par4 + 0.5F), (double)((float)par5 + 0.5F), (double)((float)par6 + 0.5F), var9.stepSound.getStepSound(), (var9.stepSound.getVolume() + 1.0F) / 2.0F, var9.stepSound.getPitch() * 0.8F);
                --par1ItemStack.stackSize;
            }

            return true;
        }
        else
        {
            return false;
        }
    }
    $else$ */
	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
	    Block var9 = Block.blocksList[getBlockID()];

        if (world.setBlockAndMetadataWithNotify(x, y, z, getBlockID(), 0))
        {
        	world.setBlockTileEntity(x, y, z, createTileEntity(stack.getItemDamage()));
            if (world.getBlockId(x, y, z) == getBlockID())
            {
                var9.updateBlockMetadata(world, x, y, z, side, hitX, hitY, hitZ);
                var9.onBlockPlacedBy(world, x, y, z, player);
            } else
            	return false;
        } else
        	return false;

        return true;
	}
	/* $endif$ */
}
