package immibis.core;

import java.util.HashMap;
import java.util.Map;

import net.minecraft.src.*;
import immibis.core.BlockMultiTile;
import immibis.core.Config;
import immibis.core.ModInfoReader;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
/* $if jclient$ */
import immibis.core.api.porting.PortableBlockRenderer;
/* $endif$ */
import immibis.core.api.porting.SidedProxy;
import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.PacketMicroblockDigStart;
import immibis.core.covers.PacketMicroblockPlace;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
import immibis.core.net.PacketButtonPress;

public class mod_ImmibisCore extends PortableBaseMod {

	public static final int PACKET_TYPE_S2C_STRING_GUI = 0; // Unused
	public static final int PACKET_TYPE_S2C_MULTIPART_DESCRIPTION = 1; // Unused (has a separate channel)
	public static final int PACKET_TYPE_C2S_MICROBLOCK_DIG_START = 2;
	public static final int PACKET_TYPE_C2S_MICROBLOCK_PLACE = 3;
	
	public static final boolean FORCE_MICROBLOCKS_DISABLED = true;
	
	public static final String CHANNEL_GUI = "Immibis1.2.5-GUI";
	public static final String CHANNEL = "ImmibisCore";
	
	/* $if !joined && client2$ */
	private static Map<Integer, PortableBlockRenderer> renderers = new HashMap<Integer, PortableBlockRenderer>();
	public boolean renderWorldBlock(RenderBlocks render, IBlockAccess world, int x, int y, int z, Block block, int model) {
		return renderers.get(model).renderWorldBlock(render, world, x, y, z, block, model);
	}
	public void renderInvBlock(RenderBlocks render, Block block, int meta, int model) {
		renderers.get(model).renderInvBlock(render, block, meta, model);
	}
	public static void setRenderer(int model, PortableBlockRenderer r) {
		renderers.put(model, r);
	}
	/* $endif$ */
	
	/* $if mc > 1.3$ */
	public static @cpw.mods.fml.common.SidedProxy(
		clientSide = "immibis.core.porting.ClientProxy132",
		serverSide = "immibis.core.porting.ServerProxy132")
			SidedProxy sidedProxy;
	/* $endif$ */
	
	@Override
	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/core/mod_ImmibisCore.info.txt", "version");
	}
	
	public static int coverModel;
	public static boolean coversEnabled;

	@Override
	public void load() {
		/* $if joined$ */
		SidedProxy.instance = sidedProxy;
		/* $endif$ */
		
		/* $if mc < 1.3$ */
		if(Config.getBoolean("enableMicroblocks", false))
		{
			coverModel = SidedProxy.instance.getUniqueBlockModelID("immibis.core.CoreBlockRenderer", true);
			CoverSystemProxy.init(coverModel);
			coversEnabled = true;
		}
		else
		/* $endif$ */
			coversEnabled = false;
		
		BlockMultiTile.model = BlockMultiTile.normalModel = SidedProxy.instance.getUniqueBlockModelID("immibis.core.CoreBlockRenderer", true);
		
		OneTwoFiveNetworking.initReceiveServer(new IPacketMap() {
			@Override
			public IPacket createPacket(byte id) {
				if(id == 0)
					return new PacketButtonPress(0);
				return null;
			}
		}, CHANNEL_GUI);
		
		OneTwoFiveNetworking.initReceiveServer(new IPacketMap() {
			@Override
			public IPacket createPacket(byte id) {
				if(mod_ImmibisCore.coversEnabled) {
					if(id == PACKET_TYPE_C2S_MICROBLOCK_DIG_START)
						return new PacketMicroblockDigStart();
					if(id == PACKET_TYPE_C2S_MICROBLOCK_PLACE)
						return new PacketMicroblockPlace();
				}
				return null;
			}
		}, CHANNEL);
	}
	
	@Override
	public void modsLoaded() {
		IDAllocator.AllocateBlockIDs();
		/* $if mc < 1.3$ */
		if(coversEnabled)
			CoverSystemProxy.ModsLoaded();
		/* $endif$ */
	}
	
	public static mod_ImmibisCore instance;
	
	public mod_ImmibisCore() {
		instance = this;
	}
	
	
	
	public static boolean areItemsEqual(ItemStack a, ItemStack b) {
		if(a == null && b == null)
			return true;
		if(a == null || b == null)
			return false;
		if(a.itemID != b.itemID)
			return false;
		if(a.getHasSubtypes() && a.getItemDamage() != b.getItemDamage())
			return false;
		if(a.stackTagCompound == null && b.stackTagCompound == null)
			return true;
		if(a.stackTagCompound != null || b.stackTagCompound != null)
			return false;
		return a.stackTagCompound.equals(b.stackTagCompound);
	}

}
