package immibis.core.porting;

/* $if mc == 1.3.2$ */

import java.io.File;

import cpw.mods.fml.common.registry.LanguageRegistry;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Packet250CustomPayload;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraftforge.common.DimensionManager;
import immibis.core.api.porting.IClientPacketHandler;
import immibis.core.api.porting.IServerPacketHandler;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;

public abstract class CommonProxy132 extends SidedProxy {
	@Override
	public boolean isWorldCurrent(World w) {
		return DimensionManager.getWorld(w.provider.dimensionId) == w;
	}
	
	@Override
	public void addLocalization(String key, String value) {
		LanguageRegistry.instance().addStringLocalization(key, value);
	}
	
	@Override
	public void sendChat(String msg, EntityPlayer player) {
		player.addChatMessage(msg);
	}
}

/* $endif$ */