package immibis.core;

import immibis.core.api.porting.SidedProxy;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;

import net.minecraft.src.forge.*;
import net.minecraftforge.common.*;

public class Config {
	private static File configFile;
	public static Configuration config;
	private static boolean autoAssign;
	
	static {
		File configFile;
		{
			File configDir = new File(SidedProxy.instance.getMinecraftDir(), "config");
			configDir.mkdir();
			configFile = new File(configDir, "immibis.cfg");
		}
		config = new Configuration(configFile);
		config.load();
		
		autoAssign = getBoolean("autoAssign", true);
		
		/* $if mc > 1.4$ */
		config.get(Configuration.CATEGORY_GENERAL, "autoAssign", false);
		/* $else$
		((Property)config.generalProperties.get("autoAssign")).value = "false";
		$endif$ */
		config.save();
	}
	
	public static boolean getBoolean(String name, boolean def)
	{
		/* $if mc > 1.4$ */
		boolean result = config.get(Configuration.CATEGORY_GENERAL, name, def).getBoolean(def);
		/* $else$
		boolean result = Boolean.valueOf(config.getOrCreateBooleanProperty(name, Configuration.CATEGORY_GENERAL, def).value);
		$endif$ */
		config.save();
		return result;
	}
	
	private static HashSet<String> forceAllowReassign = new HashSet<String>();
	
	public static void save() {
		config.save();
	}
	
	public static int getBlockID(String name, boolean allowCreation) {
		/* $if mc < 1.4$
		try {
			if(!allowCreation && !config.blockProperties.containsKey(name+".id"))
				return 0;
			return Integer.parseInt(config.getOrCreateBlockIdProperty(name+".id", 194).value);
		} catch(Exception e) {
			ModLoader.throwException("This shouldn't be possible", e);
			return 0;
		}
		$else$ */
 		if(!allowCreation && (config.categories.get(Configuration.CATEGORY_BLOCK) == null || config.categories.get(Configuration.CATEGORY_BLOCK).containsKey(name+".id")))
			return 0;
		return config.getBlock(name+".id", 194).getInt(194);
		/* $endif$ */
	}
	
	public static int getItemID(String name, int def)
	{
		/* $if mc < 1.4$
		Property prop = config.getOrCreateIntProperty(name, Configuration.CATEGORY_ITEM, def);
		$else$ */
		Property prop = config.get(Configuration.CATEGORY_ITEM, name, def);
		/* $endif$ */
		
		int id = Integer.valueOf(prop.value);
		if(Item.itemsList[id] != null || id == 0)
		{
			if(!autoAssign)
				throw new RuntimeException("Item "+name+" conflicts with "+Item.itemsList[id]+" ");
			id = -1;
			for(int k = Item.itemsList.length - 1; k >= 500; k--)
				if(Item.itemsList[k] == null)
				{
					id = k;
					break;
				}
			if(id == -1)
				throw new RuntimeException("You're out of item IDs! Oh no! Remove some mods! (And congratulations... there are OVER THIRTY THOUSAND of them!)");
			prop.value = String.valueOf(id);
			config.save();
		}
		return id;
	}
	
	public static String getString(String name, String def, String category, String comment) {
		boolean save = config.categories.get(category) == null || config.categories.get(category).get(name) == null;
		/* $if mc < 1.4$
		Property prop = config.getOrCreateProperty(name, category, def);
		$else$ */
		Property prop = config.get(category, name, def);
		/* $endif$ */
		save |= (prop.comment == null && comment != null) || !prop.comment.equals(comment);
		prop.comment = comment;
		if(save)
			config.save();
		return prop.value;
	}

	public static int getInt(String name, int def)
	{
		/* $if mc < 1.4$
		return Integer.valueOf(config.getOrCreateIntProperty(name, Configuration.CATEGORY_GENERAL, def).value);
		$else$ */
		return config.get(Configuration.CATEGORY_GENERAL, name, def).getInt(def);
		/* $endif$ */
	}
}
