package immibis.ccperiphs;

import immibis.ccperiphs.lan.BlockLANWire;
import immibis.ccperiphs.lan.EnumWireTypes;
import immibis.ccperiphs.lan.ItemLANWire;
import immibis.ccperiphs.lan.TileNIC;
import immibis.ccperiphs.rfid.DyeCardRecipe;
import immibis.ccperiphs.rfid.ItemCardBase;
import immibis.ccperiphs.rfid.TileMagStripe;
import immibis.ccperiphs.rfid.TileRFIDReader;
import immibis.ccperiphs.rfid.TileRFIDWriter;
import immibis.ccperiphs.speaker.ClientSpeaker;
import immibis.ccperiphs.speaker.PacketSpeakerStart;
import immibis.ccperiphs.speaker.PacketSpeakerStop;
import immibis.ccperiphs.speaker.PacketSpeakerStream;
import immibis.ccperiphs.speaker.TileSpeaker;
import immibis.ccperiphs.tape.ItemTape;
import immibis.core.Config;
import immibis.core.api.APILocator;
import immibis.core.api.FMLModInfo;
import immibis.core.api.IIDCallback;
import immibis.core.api.net.IPacket;
import immibis.core.api.net.IPacketMap;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.SidedProxy;
import immibis.core.api.util.Colour;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.ComputerCraft;
//import immibis.ccperiphs.smartcard.TileSCInterface;

@Mod(version = "52.0.4", name = "Immibis's Peripherals", modid = "ImmibisPeripherals", dependencies = "required-after:ImmibisCore;required-after:ComputerCraft")
@NetworkMod(serverSideRequired = false, clientSideRequired = true)
@FMLModInfo(
		url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
		description="Adds some useful and neat peripherals",
		credits="Code by immibis; card textures and ideas by ozbar11.",
		authors="immibis"
		)
public class ImmibisPeripherals extends PortableBaseMod implements IPacketMap {

	public static BlockPeriphs block;
	public static BlockLANWire lanWire;
	public static ItemCardBase itemRFID, itemMagStripe, itemSmartCard;
	public static ItemTape itemTape;
	public static ImmibisPeripherals instance;
	public static File scBaseDir;

	public static final int GUI_RFID_WRITER = 0;

	public static boolean enableLANRegistration = true;

	public static int maxTapeSizeKB = 65536;

	public static final int PKT_SPEAKER_STOP = 1;
	public static final int PKT_SPEAKER_START = 2;
	public static final int PKT_SPEAKER_STREAM = 3;

	public static String adminPassword;
	public static boolean enableSendFrom;

	public ImmibisPeripherals() {
		instance = this;
	}

	public static final String CHANNEL = "ImmPhs"; // fairly short, since speakers can send lots of packets. TODO: use packet 131

	@PreInit
	public void preinit(FMLPreInitializationEvent evt) {
		APILocator.getIDAllocator().requestBlock(this, "peripherals.block", new IIDCallback() {
			@Override
			public void register(int id) {
				block = new BlockPeriphs(id);
				ModLoader.registerBlock(block, ItemPeriphs.class);
			}
		});

		enableLANRegistration = Config.getBoolean("peripherals.enableLAN", true);
		enableSendFrom = Config.getBoolean("peripherals.enableLANSenderSpoofing", true);

		if(enableLANRegistration) {
			APILocator.getIDAllocator().requestBlock(this, "peripherals.lan-wire", new IIDCallback() {
				@Override
				public void register(int id) {
					lanWire = new BlockLANWire(id);
					ModLoader.registerBlock(lanWire, ItemLANWire.class);
				}
			});
		}

		APILocator.getIDAllocator().requestItem(this, "peripherals.rfid", new IIDCallback() {
			@Override
			public void register(int id) {
				itemRFID = new ItemCardBase(id - 256, 48);
				ModLoader.addName(itemRFID, "RFID card");
			}
		});

		APILocator.getIDAllocator().requestItem(this, "peripherals.magstripe", new IIDCallback() {
			@Override
			public void register(int id) {
				itemMagStripe = new ItemCardBase(id - 256, 48);
				ModLoader.addName(itemMagStripe, "Mag-stripe card");
			}
		});

		APILocator.getIDAllocator().addRecipes(new Runnable() {
			@SuppressWarnings("unchecked")
			@Override
			public void run() {
				CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemRFID.shiftedIndex));
				CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemMagStripe.shiftedIndex));

				if(Config.getBoolean("peripherals.enableCraftingRFIDCards", true)) {
					ModLoader.addRecipe(new ItemStack(itemRFID, 1, 0),
							"RRR",
							"PPP",
							"RRR",
							'P', Item.paper,
							'R', Item.redstone
							);
				}
				if(Config.getBoolean("peripherals.enableCraftingMagCards", true)) {
					ModLoader.addRecipe(new ItemStack(itemMagStripe, 1, 0),
							"PPP",
							"IRI",
							'P', Item.paper,
							'R', Item.redstone,
							'I', Item.ingotIron
							);
				}
				if(Config.getBoolean("peripherals.enableCraftingRFIDReader", true)) {
					ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_READER.ordinal()),
							" T ",
							"SIS",
							"SRS",
							'S', Block.stone,
							'T', Block.torchRedstoneActive,
							'R', Item.redstone,
							'I', Item.ingotIron
							);
				}
				if(Config.getBoolean("peripherals.enableCraftingRFIDWriter", true)) {
					ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_WRITER.ordinal()),
							"L-L",
							"# #",
							"SRS",
							'S', Block.stone,
							'R', Item.redstoneRepeater,
							'#', Block.blockGold,
							'-', Block.thinGlass,
							'L', Block.redstoneLampIdle
							);
				}
				if(Config.getBoolean("peripherals.enableCraftingMagCardDevice", true)) {
					ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.MAG_STRIPE.ordinal()),
							"STS",
							"SRS",
							"SSS",
							'S', Block.stone,
							'R', Item.redstone,
							'T', Block.torchRedstoneActive
							);
				}
				if(Config.getBoolean("peripherals.enableCraftingSpeaker", true)) {
					ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.SPEAKER.ordinal()),
							"S#S",
							"SNS",
							"SNS",
							'S', Block.stone,
							'N', Block.music,
							'#', Block.blockSteel
							);
				}
				if(enableLANRegistration && Config.getBoolean("peripherals.enableCraftingLANModem", true)) {
					ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.NIC.ordinal()),
							"SWS",
							"TWT",
							"SSS",
							'S', Block.stone,
							'T', Block.torchRedstoneActive,
							'W', new ItemStack(lanWire, 1, EnumWireTypes.NORMAL.ordinal())
							);
				}
				if(enableLANRegistration && Config.getBoolean("peripherals.enableCraftingLANWire", true)) {
					ModLoader.addRecipe(new ItemStack(lanWire, 16, EnumWireTypes.NORMAL.ordinal()),
							"WWW",
							"RRR",
							"WWW",
							'W', new ItemStack(Block.cloth, 1, Colour.BLUE.woolId()),
							'R', Item.redstone
							);
				}
			}
		});

	}

	@Init
	public void load(FMLInitializationEvent evt) {

		BlockPeriphs.model = SidedProxy.instance.getUniqueBlockModelID("immibis.ccperiphs.BlockRenderer", true);

		adminPassword = Config.getString("peripherals.adminPassword", "", Configuration.CATEGORY_GENERAL, "");

		if(adminPassword.isEmpty())
			adminPassword = null;

		//itemSmartCard = new ItemCardBase(Config.getItemID("peripherals.smartcard", 7436) - 256, 80);
		//itemTape = new ItemTape(Config.getItemID("peripherals.magtape", 7436) - 256, 128);

		//ModLoader.addName(itemSmartCard, "Smart card");
		//ModLoader.addName(itemTape, "Magnetic tape");


		//CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemTape.shiftedIndex));

		SidedProxy.instance.registerTileEntity(TileRFIDWriter.class, "immibis.cc-rfid.writer", "immibis.ccperiphs.rfid.RenderTileRFIDWriter");
		ModLoader.registerTileEntity(TileRFIDReader.class, "immibis.cc-rfid.reader");
		ModLoader.registerTileEntity(TileMagStripe.class, "immibis.cc-rfid.msreader");
		SidedProxy.instance.registerTileEntity(TileSpeaker.class, "immibis.cc-speaker", "immibis.ccperiphs.speaker.RenderTileSpeaker");
		//ModLoader.registerTileEntity(TileTapeDrive.class, "immibis.cc-tapedrive");
		ModLoader.registerTileEntity(TileNIC.class, "immibis.cc-lan.nic");

		//ModLoader.registerTileEntity(TileSCInterface.class, "immibis.cc-sc.writer");
		//scBaseDir = new File(mod_ComputerCraft.getBaseDir(), "mod-data/immibis-peripherals/smartcard");
		//createFakeBaseDir();

		APILocator.getNetManager().listen(this);

		enableClockTicks(false);
	}

	@PostInit
	public void postInit(FMLPostInitializationEvent evt) {
		if(ComputerCraft.creativeTab != null) {
			block.setCreativeTab(ComputerCraft.creativeTab);
			if(enableLANRegistration)
				lanWire.setCreativeTab(ComputerCraft.creativeTab);
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public boolean onTickInGame() {
		ClientSpeaker.tickSystem();

		return true;
	}

	@SuppressWarnings("unused")
	private void createFakeBaseDir() {
		copyResourceToFileIfDoesntExist("/immibis/ccperiphs/smartcard/bios.lua", new File(scBaseDir, "mods/ComputerCraft/lua/bios.lua"));
	}

	private void copyResourceToFileIfDoesntExist(String respath, File file) {
		//if(file.exists())
		//	return;
		File parent = file.getParentFile();
		if(!parent.exists() && !parent.mkdirs())
			throw new RuntimeException("Failed to create "+parent);

		try {
			InputStream in = ImmibisPeripherals.class.getResourceAsStream(respath);
			if(in == null)
				throw new RuntimeException("Failed to open resource "+respath);

			try {
				FileOutputStream out = new FileOutputStream(file);
				try {
					byte[] buf = new byte[102400];
					while(true) {
						int read = in.read(buf);
						if(read < 0)
							break;
						out.write(buf, 0, read);
					}
				} finally {
					out.close();
				}
			} finally {
				in.close();
			}
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}


	@Override
	public String getChannel() {
		return CHANNEL;
	}

	@Override
	public IPacket createS2CPacket(byte id) {
		switch(id) {
		case PKT_SPEAKER_START: return new PacketSpeakerStart();
		case PKT_SPEAKER_STOP: return new PacketSpeakerStop();
		case PKT_SPEAKER_STREAM: return new PacketSpeakerStream();
		}
		return null;
	}

	@Override
	public IPacket createC2SPacket(byte id) {
		return null;
	}
}
