package immibis.ccperiphs.rfid;

import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemCardBase extends Item {
	// Colours are stored as item metadata, using wool data values

	public ItemCardBase(int id, int iconBase) {
		super(id);
		setTextureFile("/immibis/ccperiphs/world.png");
		iconIndex = iconBase;
		setItemName("immibis.cc-rfid."+iconBase);
		setMaxStackSize(1);
	}
	
	@Override
	public boolean getShareTag() {return true;}
	
	@Override
	public int getIconFromDamage(int damage) {
		return iconIndex + damage;
	}
	
	@Override
	public void addInformation(ItemStack stack, EntityPlayer ply, List list, boolean par4) {
		if(stack.stackTagCompound == null || !stack.stackTagCompound.hasKey("data"))
			return;
		
		String line1 = stack.stackTagCompound.getString("line1");
		//String line2 = stack.stackTagCompound.getString("line2");
		//String line3 = stack.stackTagCompound.getString("line3");
		
		if(!line1.equals("")) list.add(line1);
		//if(!line2.equals("")) list.add(line2);
		//if(!line3.equals("")) list.add(line3);
	}

}
